/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static Date date = null;
    public static DateFormat dateFormat = null;
    public static Calendar calendar = null;

    public static Date parseDate(String dateStr, String format) {
        try {
            dateFormat = new SimpleDateFormat(format);
            String dt = dateStr.replaceAll("-", "/");
            if (!dt.equals("") && dt.length() < format.length()) {
                dt = dt + format.substring(dt.length()).replaceAll("[YyMmDdHhSs]", "0");
            }
            date = dateFormat.parse(dt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate(dateStr, "yyyy/MM/dd");
    }

    public static String format(Date date, String format) {
        String result = "";
        try {
            if (date != null) {
                dateFormat = new SimpleDateFormat(format);
                result = dateFormat.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String format(Date date) {
        return DateUtils.format(date, "yyyy/MM/dd");
    }

    public static int getYear(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static long getMillis(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static String getDate(Date date) {
        return DateUtils.format(date, "yyyy/MM/dd");
    }

    public static String getTime(Date date) {
        return DateUtils.format(date, "HH:mm:ss");
    }

    public static String getDateTime(Date date) {
        return DateUtils.format(date, "yyyy/MM/dd HH:mm:ss");
    }

    public static Date addDate(Date date, int day) {
        calendar = Calendar.getInstance();
        long millis = DateUtils.getMillis(date) + (long)day * 24L * 3600L * 1000L;
        calendar.setTimeInMillis(millis);
        return calendar.getTime();
    }

    public static int diffDate(Date date, Date date1) {
        return (int)((DateUtils.getMillis(date) - DateUtils.getMillis(date1)) / 86400000L);
    }

    public static String getMonthBegin(String strdate) {
        date = DateUtils.parseDate(strdate);
        return DateUtils.format(date, "yyyy-MM") + "-01";
    }

    public static String getMonthEnd(String strdate) {
        date = DateUtils.parseDate(DateUtils.getMonthBegin(strdate));
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(6, -1);
        return DateUtils.formatDate(calendar.getTime());
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDateByFormat(date, "yyyy-MM-dd");
    }

    public static String formatDateByFormat(Date date, String format) {
        String result = "";
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String getMonthDayWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int week = c.get(7);
        String weekStr = null;
        switch (week) {
            case 1: {
                weekStr = "\u5468\u65e5";
                break;
            }
            case 2: {
                weekStr = "\u5468\u4e00";
                break;
            }
            case 3: {
                weekStr = "\u5468\u4e8c";
                break;
            }
            case 4: {
                weekStr = "\u5468\u4e09";
                break;
            }
            case 5: {
                weekStr = "\u5468\u56db";
                break;
            }
            case 6: {
                weekStr = "\u5468\u4e94";
                break;
            }
            case 7: {
                weekStr = "\u5468\u516d";
            }
        }
        return month + "\u6708" + day + "\u65e5" + "(" + weekStr + ")";
    }

    public static Date formatStringByFormat(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTimeInterval(String d) {
        Date date = DateUtils.formatStringByFormat(d, "yyyy-MM-dd HH:mm:ss");
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        int nowYear = now.get(1);
        int nowMonth = now.get(2);
        int nowWeek = now.get(4);
        int nowDay = now.get(7);
        int nowHour = now.get(11);
        int nowMinute = now.get(12);
        Calendar ca = Calendar.getInstance();
        if (date != null) {
            ca.setTime(date);
        } else {
            ca.setTime(new Date());
        }
        int year = ca.get(1);
        int month = ca.get(2);
        int week = ca.get(4);
        int day = ca.get(7);
        int hour = ca.get(11);
        int minute = ca.get(12);
        if (year != nowYear) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.format(date);
        }
        if (month != nowMonth) {
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708dd\u65e5");
            return sdf.format(date);
        }
        if (week != nowWeek) {
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708dd\u65e5");
            return sdf.format(date);
        }
        if (day != nowDay) {
            if (day + 1 == nowDay) {
                return "\u6628\u5929" + DateUtils.formatDateByFormat(date, "HH:mm");
            }
            if (day + 2 == nowDay) {
                return "\u524d\u5929" + DateUtils.formatDateByFormat(date, "HH:mm");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708dd\u65e5");
            return sdf.format(date);
        }
        int hourGap = nowHour - hour;
        if (hourGap == 0) {
            if (nowMinute - minute < 1) {
                return "\u521a\u521a";
            }
            return nowMinute - minute + "\u5206\u949f\u524d";
        }
        if (hourGap >= 1 && hourGap <= 12) {
            return hourGap + "\u5c0f\u65f6\u524d";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("\u4eca\u5929 HH:mm");
        return sdf.format(date);
    }

    public static String reformatTime(String date, String pattern) {
        String fmt = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simple = new SimpleDateFormat(pattern);
        Date old = DateUtils.parseToDate(date, fmt);
        return simple.format(old);
    }

    public static Date parseToDate(String dateString, String pattern) {
        if (pattern == null || "".equals(pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.getDefault());
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public static String getTimeInterval(Date d) {
        String date = DateUtils.format(d, "yyyy-MM-dd HH:mm:ss");
        return DateUtils.getTimeInterval(date);
    }
}

