/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import cn.finalteam.toolsfinal.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static final CrashHandler INSTANCE = new CrashHandler();
    private Context mContext;
    private boolean mCrashSave;
    private String mCrashSaveTargetFolder;
    private Map<String, String> mDeviceInfoMap = new HashMap<String, String>();
    private OnCrashListener mOnCrashListener;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return INSTANCE;
    }

    public CrashHandler init(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        return this;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    public boolean handleException(Throwable ex) {
        Thread.setDefaultUncaughtExceptionHandler(null);
        if (ex == null) {
            return false;
        }
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        ex.printStackTrace(pw);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(pw);
        }
        pw.close();
        final String crashMsg = ((Object)writer).toString();
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                if (CrashHandler.this.mOnCrashListener != null) {
                    CrashHandler.this.mOnCrashListener.onCrash(CrashHandler.this.mContext, crashMsg);
                }
                Looper.loop();
            }
        }.start();
        if (this.mCrashSave) {
            this.collectDeviceInfo(this.mContext);
            this.saveCrashInfo2File(crashMsg);
        }
        return true;
    }

    public CrashHandler setOnCrashListener(OnCrashListener listener) {
        this.mOnCrashListener = listener;
        return this;
    }

    public CrashHandler setCrashSave(boolean isSave) {
        this.mCrashSave = isSave;
        return this;
    }

    public CrashHandler setCrashSaveTargetFolder(String targetFolder) {
        this.mCrashSaveTargetFolder = targetFolder;
        return this;
    }

    private void collectDeviceInfo(Context context) {
        Field[] fields;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.mDeviceInfoMap.put("versionName", versionName);
                this.mDeviceInfoMap.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.mDeviceInfoMap.put(field.getName(), field.get("").toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private String saveCrashInfo2File(String crashMsg) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mDeviceInfoMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\r\n");
        }
        sb.append(crashMsg);
        long timetamp = System.currentTimeMillis();
        SimpleDateFormat dateFomat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String time = dateFomat.format(new Date());
        String fileName = "crash-" + time + "-" + timetamp + ".log";
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                File dir = StringUtils.isEmpty(this.mCrashSaveTargetFolder) ? new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "crash") : new File(this.mCrashSaveTargetFolder);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                FileOutputStream fos = new FileOutputStream(new File(dir, fileName));
                fos.write(sb.toString().getBytes());
                fos.close();
                return fileName;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static interface OnCrashListener {
        public void onCrash(Context var1, String var2);
    }
}

