/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

public abstract class CountDownTimer {
    private static final int MSG = 1;
    private final long mMillisInFuture;
    private final long mCountdownInterval;
    private boolean mCanceled = false;
    private long mStopTimeInFuture;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            CountDownTimer countDownTimer = CountDownTimer.this;
            synchronized (countDownTimer) {
                long millisLeft = CountDownTimer.this.mStopTimeInFuture - SystemClock.elapsedRealtime();
                if (millisLeft <= 0L || CountDownTimer.this.mCanceled) {
                    CountDownTimer.this.onFinish();
                } else if (millisLeft < CountDownTimer.this.mCountdownInterval) {
                    this.sendMessageDelayed(this.obtainMessage(1), millisLeft);
                } else {
                    long delay;
                    long lastTickStart = SystemClock.elapsedRealtime();
                    CountDownTimer.this.onTick(millisLeft);
                    for (delay = lastTickStart + CountDownTimer.this.mCountdownInterval - SystemClock.elapsedRealtime(); delay < 0L; delay += CountDownTimer.this.mCountdownInterval) {
                    }
                    this.sendMessageDelayed(this.obtainMessage(1), delay);
                }
            }
        }
    };

    public CountDownTimer(long millisInFuture, long countDownInterval) {
        this.mMillisInFuture = millisInFuture;
        this.mCountdownInterval = countDownInterval;
    }

    public final void cancel() {
        this.mHandler.removeMessages(1);
        this.mCanceled = true;
    }

    public final synchronized CountDownTimer start() {
        if (this.mMillisInFuture <= 0L) {
            this.onFinish();
            return this;
        }
        this.mStopTimeInFuture = SystemClock.elapsedRealtime() + this.mMillisInFuture;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        this.mCanceled = false;
        return this;
    }

    public abstract void onTick(long var1);

    public abstract void onFinish();
}

