/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.content.Context;
import cn.finalteam.toolsfinal.StorageUtils;
import cn.finalteam.toolsfinal.StringUtils;
import cn.finalteam.toolsfinal.coder.MD5Coder;
import cn.finalteam.toolsfinal.io.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppCacheUtils {
    public static final String DEFAULT_CACHE_NAME = "appCache";
    private File mCacheFile;
    private static Map<String, AppCacheUtils> mCacheUtilsMap = new HashMap<String, AppCacheUtils>();

    private AppCacheUtils(File cacheFile) {
        this.mCacheFile = cacheFile;
        FileUtils.mkdirs(cacheFile);
    }

    public static AppCacheUtils getInstance(Context ctx) {
        return AppCacheUtils.getInstance(StorageUtils.getIndividualCacheDirectory(ctx));
    }

    public static AppCacheUtils getInstance(String path, String cacheDirName) {
        return AppCacheUtils.getInstance(new File(path, cacheDirName));
    }

    public static AppCacheUtils getInstance(Context ctx, String cacheDirName) {
        return AppCacheUtils.getInstance(new File(StorageUtils.getIndividualCacheDirectory(ctx), cacheDirName));
    }

    public static AppCacheUtils getInstance(File file) {
        AppCacheUtils appCacheUtils = mCacheUtilsMap.get(file.getAbsolutePath());
        if (appCacheUtils == null) {
            appCacheUtils = new AppCacheUtils(file);
            mCacheUtilsMap.put(file.getAbsolutePath(), appCacheUtils);
        }
        return appCacheUtils;
    }

    public void put(String key, int value) {
        this.put(key, value + "");
    }

    public void put(String key, float value) {
        this.put(key, value + "");
    }

    public void put(String key, double value) {
        this.put(key, value + "");
    }

    public void put(String key, boolean value) {
        this.put(key, value + "");
    }

    public void put(String key, long value) {
        this.put(key, value + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        if (StringUtils.isEmpty(key)) {
            return;
        }
        if (StringUtils.isEmpty(value)) {
            value = "";
        }
        File file = this.newFile(key);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file), 1024);
            out.write(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, byte[] value) {
        if (value == null || value.length == 0 || StringUtils.isEmpty(key)) {
            return;
        }
        File file = this.newFile(key);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void put(String key, JSONArray value) {
        if (value == null) {
            return;
        }
        this.put(key, value.toString());
    }

    public void put(String key, JSONObject value) {
        if (value == null) {
            return;
        }
        this.put(key, value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Serializable value) {
        if (StringUtils.isEmpty(key) || value == null) {
            return;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            byte[] data = baos.toByteArray();
            this.put(key, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getInt(String key, int defValue) {
        String sValue = this.getString(key);
        if (!StringUtils.isEmpty(sValue)) {
            try {
                int iValue = Integer.parseInt(sValue);
                return iValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    public float getFloat(String key, float defValue) {
        String sValue = this.getString(key);
        if (!StringUtils.isEmpty(sValue)) {
            try {
                float fValue = Float.parseFloat(sValue);
                return fValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    public Double getDouble(String key, double defValue) {
        String sValue = this.getString(key);
        if (!StringUtils.isEmpty(sValue)) {
            try {
                double dValue = Double.parseDouble(sValue);
                return dValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    public long getLong(String key, long defValue) {
        String sValue = this.getString(key);
        if (!StringUtils.isEmpty(sValue)) {
            try {
                long dValue = Long.parseLong(sValue);
                return dValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    public boolean getBoolean(String key, boolean defValue) {
        String sValue = this.getString(key);
        if (!StringUtils.isEmpty(sValue)) {
            try {
                boolean bValue = Boolean.parseBoolean(sValue);
                return bValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        File file = this.newFile(key);
        if (!file.exists()) {
            return null;
        }
        BufferedReader in = null;
        String readString = "";
        try {
            String currentLine;
            in = new BufferedReader(new FileReader(file));
            while ((currentLine = in.readLine()) != null) {
                readString = readString + currentLine;
            }
            String string = readString;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return readString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        byte[] data = this.getBinary(key);
        if (data != null) {
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                Object reObject;
                bais = new ByteArrayInputStream(data);
                ois = new ObjectInputStream(bais);
                Object object = reObject = ois.readObject();
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var6_8 = null;
                return var6_8;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinary(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        RandomAccessFile rAFile = null;
        byte[] byteArray = null;
        try {
            File file = this.newFile(key);
            if (!file.exists()) {
                byte[] byArray = null;
                return byArray;
            }
            rAFile = new RandomAccessFile(file, "r");
            long fLength = rAFile.length();
            if (fLength != 0L) {
                byteArray = new byte[(int)rAFile.length()];
                rAFile.read(byteArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rAFile != null) {
                try {
                    rAFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return byteArray;
    }

    public JSONArray getJSONArray(String key) {
        String JSONString = this.getString(key);
        try {
            JSONArray obj = new JSONArray(JSONString);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject getJSONObject(String key) {
        String JSONString = this.getString(key);
        try {
            JSONObject obj = new JSONObject(JSONString);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private File newFile(String key) {
        return new File(this.mCacheFile, MD5Coder.getMD5Code(key));
    }

    public void remove(String key) {
        try {
            this.newFile(key).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

