/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import cn.finalteam.loadingviewfinal.DefaultLoadMoreView;
import cn.finalteam.loadingviewfinal.ILoadMoreView;
import cn.finalteam.loadingviewfinal.LoadMoreMode;
import cn.finalteam.loadingviewfinal.OnLoadMoreListener;
import cn.finalteam.loadingviewfinal.OnScrollBottomListener;
import cn.finalteam.loadingviewfinal.loadingview.R;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class ScrollViewFinal
extends ScrollView
implements OnScrollBottomListener {
    ILoadMoreView mLoadMoreView;
    LoadMoreMode mLoadMoreMode = LoadMoreMode.CLICK;
    private boolean mLoadMoreLock;
    boolean mHasLoadMore = true;
    private boolean mHasLoadFail;
    private OnLoadMoreListener mOnLoadMoreListener;
    private boolean mAddLoadMoreFooterFlag;
    private List<View> mFooterViewTempList = new ArrayList<View>();
    private List<View> mHeaderViewTempList = new ArrayList<View>();
    private LinearLayout mSvContentView;
    private boolean mNoLoadMoreHideView;

    public ScrollViewFinal(Context context) {
        super(context);
        this.init(context, null);
    }

    public ScrollViewFinal(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ScrollViewFinal(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingViewFinal);
        this.mLoadMoreMode = a.hasValue(R.styleable.LoadingViewFinal_loadMoreMode) ? LoadMoreMode.mapIntToValue(a.getInt(R.styleable.LoadingViewFinal_loadMoreMode, 1)) : LoadMoreMode.SCROLL;
        this.mNoLoadMoreHideView = a.hasValue(R.styleable.LoadingViewFinal_noLoadMoreHideView) ? a.getBoolean(R.styleable.LoadingViewFinal_noLoadMoreHideView, false) : false;
        if (a.hasValue(R.styleable.LoadingViewFinal_loadMoreView)) {
            try {
                ILoadMoreView loadMoreView;
                String loadMoreViewName = a.getString(R.styleable.LoadingViewFinal_loadMoreView);
                Class<?> clazz = Class.forName(loadMoreViewName);
                Constructor<?> c = clazz.getConstructor(Context.class);
                this.mLoadMoreView = loadMoreView = (ILoadMoreView)c.newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mLoadMoreView = new DefaultLoadMoreView(context);
            }
        } else {
            this.mLoadMoreView = new DefaultLoadMoreView(context);
        }
        this.mLoadMoreView.getFooterView().setOnClickListener((View.OnClickListener)new OnMoreViewClickListener());
        a.recycle();
        this.setHasLoadMore(false);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (t + this.getHeight() >= this.computeVerticalScrollRange()) {
            this.onScorllBootom();
        }
    }

    @Override
    public void onScorllBootom() {
        if (this.mHasLoadMore && this.mLoadMoreMode == LoadMoreMode.SCROLL) {
            this.executeLoadMore();
        }
    }

    public void setLoadMoreView(ILoadMoreView loadMoreView) {
        if (this.mLoadMoreView != null) {
            try {
                this.removeFooterView(this.mLoadMoreView.getFooterView());
                this.mAddLoadMoreFooterFlag = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mLoadMoreView = loadMoreView;
        this.mLoadMoreView.getFooterView().setOnClickListener((View.OnClickListener)new OnMoreViewClickListener());
    }

    public void setLoadMoreMode(LoadMoreMode mode) {
        this.mLoadMoreMode = mode;
    }

    public void setNoLoadMoreHideView(boolean hide) {
        this.mNoLoadMoreHideView = hide;
    }

    void showNoMoreUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNoMore();
    }

    public void showFailUI() {
        this.mHasLoadFail = true;
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showFail();
    }

    void showNormalUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNormal();
    }

    void showLoadingUI() {
        this.mHasLoadFail = false;
        this.mLoadMoreView.showLoading();
    }

    public void setHasLoadMore(boolean hasLoadMore) {
        this.mHasLoadMore = hasLoadMore;
        if (!this.mHasLoadMore) {
            this.showNoMoreUI();
            if (this.mNoLoadMoreHideView) {
                this.mAddLoadMoreFooterFlag = false;
                this.removeFooterView(this.mLoadMoreView.getFooterView());
            }
        } else {
            if (!this.mAddLoadMoreFooterFlag) {
                this.mAddLoadMoreFooterFlag = true;
                this.addFooterView(this.mLoadMoreView.getFooterView());
            }
            this.showNormalUI();
        }
    }

    public void setOnLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    public void onLoadMoreComplete() {
        if (this.mHasLoadFail) {
            this.showFailUI();
        } else if (this.mHasLoadMore) {
            this.showNormalUI();
        }
    }

    void executeLoadMore() {
        if (!this.mLoadMoreLock && this.mHasLoadMore) {
            if (this.mOnLoadMoreListener != null) {
                this.mOnLoadMoreListener.loadMore();
            }
            this.mLoadMoreLock = true;
            this.showLoadingUI();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = this.getChildAt(0);
        if (view instanceof LinearLayout) {
            int i;
            this.mSvContentView = (LinearLayout)view;
            for (i = 0; i < this.mHeaderViewTempList.size(); ++i) {
                View headerView = this.mHeaderViewTempList.get(i);
                this.mSvContentView.addView(headerView, i, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            }
            for (i = 0; i < this.mFooterViewTempList.size(); ++i) {
                View footerView = this.mFooterViewTempList.get(i);
                this.mSvContentView.addView(footerView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            }
        } else {
            throw new IllegalStateException("ScrollView child view must be a LinearLayout");
        }
    }

    public void addFooterView(View view) {
        this.mFooterViewTempList.add(view);
        if (this.mSvContentView != null) {
            int childCount = this.mSvContentView.getChildCount();
            this.mSvContentView.addView(view, childCount);
        }
    }

    public void removeFooterView(View view) {
        this.mFooterViewTempList.remove(view);
        if (this.mSvContentView != null) {
            this.mSvContentView.removeView(view);
        }
    }

    public void addHeaderView(View view) {
        this.mHeaderViewTempList.add(view);
        if (this.mSvContentView != null) {
            this.mSvContentView.addView(view, this.mHeaderViewTempList.size());
        }
    }

    public void removeHeaderView(View view) {
        this.mHeaderViewTempList.remove(view);
        if (this.mSvContentView != null) {
            this.mSvContentView.removeView(view);
        }
    }

    class OnMoreViewClickListener
    implements View.OnClickListener {
        OnMoreViewClickListener() {
        }

        public void onClick(View view) {
            if (ScrollViewFinal.this.mHasLoadMore) {
                ScrollViewFinal.this.executeLoadMore();
            }
        }
    }
}

