/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ByteUtils {
    public static byte[] stream2Bytes(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output.toByteArray();
    }

    public static short bytes2Short2(byte[] b) {
        short i = (short)((b[1] & 0xFF) << 8 | b[0] & 0xFF);
        return i;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        int iMax = bytes.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.format("%02x", bytes[i] & 0xFF));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String bytes2HexStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            b.append(String.format("%02x", bytes[i] & 0xFF));
        }
        return b.toString();
    }

    public static byte[] hexStr2Bytes(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new byte[0];
        }
        byte[] byteArray = new byte[str.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String subStr = str.substring(2 * i, 2 * i + 2);
            byteArray[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return byteArray;
    }

    public static byte[] short2Bytes(short value) {
        byte[] data = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return data;
    }

    public static byte[] int2byte(int res) {
        byte[] targets = new byte[]{(byte)(res & 0xFF), (byte)(res >> 8 & 0xFF), (byte)(res >> 16 & 0xFF), (byte)(res >>> 24)};
        return targets;
    }

    public static int byte2int(byte[] res) {
        int targets = res[0] & 0xFF | res[1] << 8 & 0xFF00 | res[2] << 24 >>> 8 | res[3] << 24;
        return targets;
    }

    public static byte[] getBytes(boolean data) {
        byte[] bytes = new byte[]{(byte)(data ? 1 : 0)};
        return bytes;
    }

    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[2];
        if (ByteUtils.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)((data & 0xFF00) >> 8);
        } else {
            bytes[1] = (byte)(data & 0xFF);
            bytes[0] = (byte)((data & 0xFF00) >> 8);
        }
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[2];
        if (ByteUtils.isLittleEndian()) {
            bytes[0] = (byte)data;
            bytes[1] = (byte)(data >> 8);
        } else {
            bytes[1] = (byte)data;
            bytes[0] = (byte)(data >> 8);
        }
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[4];
        if (ByteUtils.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)((data & 0xFF00) >> 8);
            bytes[2] = (byte)((data & 0xFF0000) >> 16);
            bytes[3] = (byte)((data & 0xFF000000) >> 24);
        } else {
            bytes[3] = (byte)(data & 0xFF);
            bytes[2] = (byte)((data & 0xFF00) >> 8);
            bytes[1] = (byte)((data & 0xFF0000) >> 16);
            bytes[0] = (byte)((data & 0xFF000000) >> 24);
        }
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[8];
        if (ByteUtils.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFFL);
            bytes[1] = (byte)(data >> 8 & 0xFFL);
            bytes[2] = (byte)(data >> 16 & 0xFFL);
            bytes[3] = (byte)(data >> 24 & 0xFFL);
            bytes[4] = (byte)(data >> 32 & 0xFFL);
            bytes[5] = (byte)(data >> 40 & 0xFFL);
            bytes[6] = (byte)(data >> 48 & 0xFFL);
            bytes[7] = (byte)(data >> 56 & 0xFFL);
        } else {
            bytes[7] = (byte)(data & 0xFFL);
            bytes[6] = (byte)(data >> 8 & 0xFFL);
            bytes[5] = (byte)(data >> 16 & 0xFFL);
            bytes[4] = (byte)(data >> 24 & 0xFFL);
            bytes[3] = (byte)(data >> 32 & 0xFFL);
            bytes[2] = (byte)(data >> 40 & 0xFFL);
            bytes[1] = (byte)(data >> 48 & 0xFFL);
            bytes[0] = (byte)(data >> 56 & 0xFFL);
        }
        return bytes;
    }

    public static byte[] getBytes(float data) {
        return ByteUtils.getBytes(Float.floatToIntBits(data));
    }

    public static byte[] getBytes(double data) {
        return ByteUtils.getBytes(Double.doubleToLongBits(data));
    }

    public static byte[] getBytes(String data) {
        return data.getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] getBytes(String data, String charsetName) {
        return data.getBytes(Charset.forName(charsetName));
    }

    public static boolean toBoolean(byte[] bytes) {
        return bytes[0] != 0;
    }

    public static boolean toBoolean(byte[] bytes, int startIndex) {
        return ByteUtils.toBoolean(ByteUtils.copyFrom(bytes, startIndex, 1));
    }

    public static short toShort(byte[] bytes) {
        if (ByteUtils.isLittleEndian()) {
            return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
        }
        return (short)(0xFF & bytes[1] | 0xFF00 & bytes[0] << 8);
    }

    public static short toShort(byte[] bytes, int startIndex) {
        return ByteUtils.toShort(ByteUtils.copyFrom(bytes, startIndex, 2));
    }

    public static char toChar(byte[] bytes) {
        if (ByteUtils.isLittleEndian()) {
            return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
        }
        return (char)(0xFF & bytes[1] | 0xFF00 & bytes[0] << 8);
    }

    public static char toChar(byte[] bytes, int startIndex) {
        return ByteUtils.toChar(ByteUtils.copyFrom(bytes, startIndex, 2));
    }

    public static int toInt(byte[] bytes) {
        if (ByteUtils.isLittleEndian()) {
            return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
        }
        return 0xFF & bytes[3] | 0xFF00 & bytes[2] << 8 | 0xFF0000 & bytes[1] << 16 | 0xFF000000 & bytes[0] << 24;
    }

    public static int toInt(byte[] bytes, int startIndex) {
        return ByteUtils.toInt(ByteUtils.copyFrom(bytes, startIndex, 4));
    }

    public static long toLong(byte[] bytes) {
        if (ByteUtils.isLittleEndian()) {
            return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
        }
        return 0xFFL & (long)bytes[7] | 0xFF00L & (long)bytes[6] << 8 | 0xFF0000L & (long)bytes[5] << 16 | 0xFF000000L & (long)bytes[4] << 24 | 0xFF00000000L & (long)bytes[3] << 32 | 0xFF0000000000L & (long)bytes[2] << 40 | 0xFF000000000000L & (long)bytes[1] << 48 | 0xFF00000000000000L & (long)bytes[0] << 56;
    }

    public static long toLong(byte[] bytes, int startIndex) {
        return ByteUtils.toLong(ByteUtils.copyFrom(bytes, startIndex, 8));
    }

    public static float toFloat(byte[] bytes) {
        return Float.intBitsToFloat(ByteUtils.toInt(bytes));
    }

    public static float toFloat(byte[] bytes, int startIndex) {
        return Float.intBitsToFloat(ByteUtils.toInt(ByteUtils.copyFrom(bytes, startIndex, 4)));
    }

    public static double toDouble(byte[] bytes) {
        return Double.longBitsToDouble(ByteUtils.toLong(bytes));
    }

    public static double toDouble(byte[] bytes, int startIndex) {
        return Double.longBitsToDouble(ByteUtils.toLong(ByteUtils.copyFrom(bytes, startIndex, 8)));
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public static String toString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    private static byte[] copyFrom(byte[] src, int off, int len) {
        byte[] bits = new byte[len];
        int i = off;
        for (int j = 0; i < src.length && j < len; ++i, ++j) {
            bits[j] = src[i];
        }
        return bits;
    }

    private static boolean isLittleEndian() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }
}

