/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Handler;
import android.support.v4.os.HandlerCompat;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleHandler;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleScanCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ScanWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.model.ScanRecord;
import cn.com.heaton.blelibrary.ble.scan.BleScannerCompat;
import cn.com.heaton.blelibrary.ble.utils.Utils;
import java.util.ArrayList;

@Implement(value=ScanRequest.class)
public class ScanRequest<T extends BleDevice>
implements ScanWrapperCallback {
    private static final String TAG = "ScanRequest";
    private static final String HANDLER_TOKEN = "stop_token";
    private boolean scanning;
    private BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private BleScanCallback<T> bleScanCallback;
    private ArrayList<T> scanDevices = new ArrayList();
    private Handler handler = BleHandler.of();
    private BleWrapperCallback<T> bleWrapperCallback;

    protected ScanRequest() {
        Ble.Options options = Ble.options();
        this.bleWrapperCallback = options.bleWrapperCallback;
    }

    public void startScan(BleScanCallback<T> callback, long scanPeriod) {
        if (callback == null) {
            throw new IllegalArgumentException("BleScanCallback can not be null!");
        }
        this.bleScanCallback = callback;
        if (!Utils.isPermission(Ble.getInstance().getContext(), "android.permission.ACCESS_COARSE_LOCATION")) {
            if (this.bleScanCallback != null) {
                this.bleScanCallback.onScanFailed(2008);
            }
            return;
        }
        if (!this.isEnableInternal()) {
            return;
        }
        if (this.scanning) {
            if (this.bleScanCallback != null) {
                this.bleScanCallback.onScanFailed(2020);
            }
            return;
        }
        if (scanPeriod >= 0L) {
            HandlerCompat.postDelayed((Handler)this.handler, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ScanRequest.this.scanning) {
                        ScanRequest.this.stopScan();
                    }
                }
            }, (Object)HANDLER_TOKEN, (long)scanPeriod);
        }
        BleScannerCompat.getScanner().startScan(this);
    }

    private boolean isEnableInternal() {
        if (!this.bluetoothAdapter.isEnabled() && this.bleScanCallback != null) {
            this.bleScanCallback.onScanFailed(2006);
            return false;
        }
        return true;
    }

    public void stopScan() {
        if (!this.isEnableInternal()) {
            return;
        }
        if (!this.scanning) {
            if (this.bleScanCallback != null) {
                this.bleScanCallback.onScanFailed(2021);
            }
            return;
        }
        this.handler.removeCallbacksAndMessages((Object)HANDLER_TOKEN);
        BleScannerCompat.getScanner().stopScan();
    }

    @Override
    public void onStart() {
        this.scanning = true;
        if (this.bleScanCallback != null) {
            this.bleScanCallback.onStart();
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onStart();
        }
    }

    @Override
    public void onStop() {
        this.scanning = false;
        if (this.bleScanCallback != null) {
            this.bleScanCallback.onStop();
            this.bleScanCallback = null;
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onStop();
        }
        this.scanDevices.clear();
    }

    @Override
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        T bleDevice = this.getDevice(device.getAddress());
        if (bleDevice == null) {
            bleDevice = Ble.options().getFactory().create(device.getAddress(), device.getName());
            if (this.bleScanCallback != null) {
                this.bleScanCallback.onLeScan(bleDevice, rssi, scanRecord);
            }
            if (this.bleWrapperCallback != null) {
                this.bleWrapperCallback.onLeScan(bleDevice, rssi, scanRecord);
            }
            this.scanDevices.add(bleDevice);
        } else if (!Ble.options().isIgnoreRepeat) {
            if (this.bleScanCallback != null) {
                this.bleScanCallback.onLeScan(bleDevice, rssi, scanRecord);
            }
            if (this.bleWrapperCallback != null) {
                this.bleWrapperCallback.onLeScan(bleDevice, rssi, scanRecord);
            }
        }
    }

    @Override
    public void onScanFailed(int errorCode) {
        if (this.bleScanCallback != null) {
            this.bleScanCallback.onScanFailed(errorCode);
        }
    }

    @Override
    public void onParsedData(BluetoothDevice device, ScanRecord scanRecord) {
        if (this.bleScanCallback != null) {
            T bleDevice = this.getDevice(device.getAddress());
            if (Build.VERSION.SDK_INT >= 21) {
                this.bleScanCallback.onParsedData(bleDevice, scanRecord);
            }
        }
    }

    public boolean isScanning() {
        return this.scanning;
    }

    private T getDevice(String address) {
        for (BleDevice device : this.scanDevices) {
            if (!device.getBleAddress().equals(address)) continue;
            return (T)device;
        }
        return null;
    }

    public void cancelScanCallback() {
        this.bleScanCallback = null;
    }
}

