/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.content.Context;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rproxy {
    private static Map<Class, Object> requestObjs;

    public static void init(Class ... clss) {
        requestObjs = new HashMap<Class, Object>();
        for (Class cls : clss) {
            if (!cls.isAnnotationPresent(Implement.class)) continue;
            for (Annotation ann : cls.getDeclaredAnnotations()) {
                if (!(ann instanceof Implement)) continue;
                try {
                    requestObjs.put(cls, ((Implement)ann).value().newInstance());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> T getRequest(Class cls) {
        Object t = requestObjs.get(cls);
        if (t != null) {
            return (T)t;
        }
        return Rproxy.getRequestByReflect(cls);
    }

    private static <T> T getRequestByReflect(Class cls) {
        try {
            Constructor constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T request = null;
            try {
                request = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return request;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new NoClassDefFoundError("Class not Request Type");
        }
    }

    public static void release() {
        requestObjs.clear();
        BleLog.d("Rproxy", "Request proxy cache is released");
    }

    private List<Class> getRequestsClass(Context context, String packageName) {
        ArrayList<Class> classRequestsList = new ArrayList<Class>();
        try {
            DexFile df = new DexFile(context.getPackageCodePath());
            Enumeration enumeration = df.entries();
            while (enumeration.hasMoreElements()) {
                String className = (String)enumeration.nextElement();
                if (!className.contains(packageName) || className.contains("$")) continue;
                try {
                    Class<?> requestCls = Class.forName(className);
                    classRequestsList.add(requestCls);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classRequestsList;
    }
}

