/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothGattCharacteristic;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleReadCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ReadWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import java.util.UUID;

@Implement(value=ReadRequest.class)
public class ReadRequest<T extends BleDevice>
implements ReadWrapperCallback<T> {
    private BleReadCallback<T> bleReadCallback;
    private BleWrapperCallback<T> bleWrapperCallback;

    protected ReadRequest() {
        this.bleWrapperCallback = Ble.options().bleWrapperCallback;
    }

    public boolean read(T device, BleReadCallback<T> callback) {
        this.bleReadCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.readCharacteristic(((BleDevice)device).getBleAddress());
    }

    public boolean readByUuid(T device, UUID serviceUUID, UUID characteristicUUID, BleReadCallback<T> callback) {
        this.bleReadCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.readCharacteristicByUuid(((BleDevice)device).getBleAddress(), serviceUUID, characteristicUUID);
    }

    @Override
    public void onReadSuccess(T device, BluetoothGattCharacteristic characteristic) {
        if (this.bleReadCallback != null) {
            this.bleReadCallback.onReadSuccess(device, characteristic);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onReadSuccess(device, characteristic);
        }
    }

    @Override
    public void onReadFailed(T device, int failedCode) {
        if (this.bleReadCallback != null) {
            this.bleReadCallback.onReadFailed(device, failedCode);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onReadFailed(device, failedCode);
        }
    }
}

