/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothGattDescriptor;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleReadDescCallback;
import cn.com.heaton.blelibrary.ble.callback.BleWriteDescCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.DescWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import java.util.UUID;

@Implement(value=DescriptorRequest.class)
public class DescriptorRequest<T extends BleDevice>
implements DescWrapperCallback<T> {
    private BleReadDescCallback<T> bleReadDescCallback;
    private BleWriteDescCallback<T> bleWriteDescCallback;
    private BleWrapperCallback<T> bleWrapperCallback;

    protected DescriptorRequest() {
        this.bleWrapperCallback = Ble.options().bleWrapperCallback;
    }

    public boolean readDes(T device, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID, BleReadDescCallback<T> callback) {
        this.bleReadDescCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.readDescriptor(((BleDevice)device).getBleAddress(), serviceUUID, characteristicUUID, descriptorUUID);
    }

    public boolean writeDes(T device, byte[] data, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID, BleWriteDescCallback<T> callback) {
        this.bleWriteDescCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.writeDescriptor(((BleDevice)device).getBleAddress(), data, serviceUUID, characteristicUUID, descriptorUUID);
    }

    @Override
    public void onDescReadSuccess(T device, BluetoothGattDescriptor descriptor) {
        if (this.bleReadDescCallback != null) {
            this.bleReadDescCallback.onDescReadSuccess(device, descriptor);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onDescReadSuccess(device, descriptor);
        }
    }

    @Override
    public void onDescReadFailed(T device, int failedCode) {
        if (this.bleReadDescCallback != null) {
            this.bleReadDescCallback.onDescReadFailed(device, failedCode);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onDescReadFailed(device, failedCode);
        }
    }

    @Override
    public void onDescWriteSuccess(T device, BluetoothGattDescriptor descriptor) {
        if (this.bleWriteDescCallback != null) {
            this.bleWriteDescCallback.onDescWriteSuccess(device, descriptor);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onDescWriteSuccess(device, descriptor);
        }
    }

    @Override
    public void onDescWriteFailed(T device, int failedCode) {
        if (this.bleWriteDescCallback != null) {
            this.bleWriteDescCallback.onDescWriteFailed(device, failedCode);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onDescWriteFailed(device, failedCode);
        }
    }
}

