/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothGatt;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleConnectCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ConnectWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.queue.ConnectQueue;
import cn.com.heaton.blelibrary.ble.queue.RequestTask;
import cn.com.heaton.blelibrary.ble.request.BleConnectTask;
import cn.com.heaton.blelibrary.ble.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Implement(value=ConnectRequest.class)
public class ConnectRequest<T extends BleDevice>
implements ConnectWrapperCallback<T> {
    private static final String TAG = "ConnectRequest";
    private static final long DEFAULT_CONNECT_DELAY = 2000L;
    private BleConnectCallback<T> connectCallback;
    private ArrayList<T> devices = new ArrayList();
    private ArrayList<T> connectedDevices = new ArrayList();
    private ArrayList<T> autoDevices = new ArrayList();
    private BleConnectTask<T> task = new BleConnectTask();
    private BleRequestImpl<T> bleRequest = BleRequestImpl.getBleRequest();
    private BleWrapperCallback<T> bleWrapperCallback;

    protected ConnectRequest() {
        this.bleWrapperCallback = Ble.options().bleWrapperCallback;
    }

    public boolean reconnect(String address) {
        for (BleDevice device : this.autoDevices) {
            if (!TextUtils.equals((CharSequence)address, (CharSequence)device.getBleAddress())) continue;
            return this.connect(device, this.connectCallback);
        }
        return false;
    }

    public boolean connect(T device, BleConnectCallback<T> callback) {
        this.connectCallback = callback;
        if (device == null) {
            this.doConnectException(device, 2041);
            return false;
        }
        if (((BleDevice)device).isConnecting()) {
            return false;
        }
        if (!Ble.getInstance().isBleEnable()) {
            this.doConnectException(device, 2006);
            return false;
        }
        if (this.connectedDevices.size() >= Ble.options().getMaxConnectNum()) {
            BleLog.e(TAG, "Maximum number of connections Exception");
            this.doConnectException(device, 2034);
            return false;
        }
        this.addBleToPool(device);
        return this.bleRequest.connect(device);
    }

    private void doConnectException(T device, int errorCode) {
        this.runOnUiThread(new Runnable((BleDevice)device, errorCode){
            final /* synthetic */ BleDevice val$device;
            final /* synthetic */ int val$errorCode;
            {
                this.val$device = bleDevice;
                this.val$errorCode = n;
            }

            @Override
            public void run() {
                if (ConnectRequest.this.connectCallback != null) {
                    ConnectRequest.this.connectCallback.onConnectException(this.val$device, this.val$errorCode);
                }
            }
        });
    }

    public boolean connect(String address, BleConnectCallback<T> callback) {
        Object bleDevice = Ble.options().getFactory().create(address, "");
        return this.connect(bleDevice, callback);
    }

    public void connect(List<T> devices, final BleConnectCallback<T> callback) {
        this.task.excute(devices, new BleConnectTask.NextCallback<T>(){

            @Override
            public void onNext(T device) {
                ConnectRequest.this.connect(device, callback);
            }
        });
    }

    public void cancelConnecting(T device) {
        boolean connecting = ((BleDevice)device).isConnecting();
        boolean ready_connect = this.task.isContains(device);
        if (connecting || ready_connect) {
            if (null != this.connectCallback) {
                BleLog.d(TAG, "cancel connecting device\uff1a" + ((BleDevice)device).getBleName());
                this.connectCallback.onConnectCancel(device);
            }
            if (connecting) {
                this.disconnect(((BleDevice)device).getBleAddress());
                this.bleRequest.cancelTimeout(((BleDevice)device).getBleAddress());
                ((BleDevice)device).setConnectionState(0);
                this.onConnectionChanged(device);
            }
            if (ready_connect) {
                this.task.cancelOne(device);
            }
        }
    }

    public void cancelConnectings(List<T> devices) {
        for (BleDevice device : devices) {
            this.cancelConnecting(device);
        }
    }

    public void disconnect(String address) {
        ArrayList<T> connectedDevices = this.getConnectedDevices();
        for (BleDevice bleDevice : connectedDevices) {
            if (!bleDevice.getBleAddress().equals(address)) continue;
            bleDevice.setAutoConnect(false);
        }
        this.bleRequest.disconnect(address);
    }

    public void disconnect(BleDevice device) {
        if (device != null) {
            this.disconnect(device.getBleAddress());
        }
    }

    public void disconnect(BleDevice device, BleConnectCallback<T> callback) {
        if (device != null) {
            this.disconnect(device.getBleAddress());
            this.connectCallback = callback;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void closeBluetooth() {
        if (!this.connectedDevices.isEmpty()) {
            for (BleDevice device : this.connectedDevices) {
                if (null == this.connectCallback) continue;
                device.setConnectionState(0);
                BleLog.e(TAG, "System Bluetooth is disconnected>>>> " + device.getBleName());
                this.connectCallback.onConnectionChanged(device);
            }
            this.bleRequest.close();
            this.connectedDevices.clear();
            this.devices.clear();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void openBluetooth() {
        BleLog.i(TAG, "auto devices size\uff1a" + this.autoDevices.size());
        for (BleDevice device : this.autoDevices) {
            this.addAutoPool(device);
        }
    }

    private void runOnUiThread(Runnable runnable) {
        ThreadUtils.ui(runnable);
    }

    @Override
    public void onConnectionChanged(T bleDevice) {
        if (bleDevice == null) {
            return;
        }
        if (((BleDevice)bleDevice).isConnected()) {
            this.connectedDevices.add(bleDevice);
            BleLog.d(TAG, "connected>>>> " + ((BleDevice)bleDevice).getBleName());
            this.removeAutoPool((BleDevice)bleDevice);
        } else if (((BleDevice)bleDevice).isDisconnected()) {
            this.connectedDevices.remove(bleDevice);
            this.devices.remove(bleDevice);
            BleLog.d(TAG, "disconnected>>>> " + ((BleDevice)bleDevice).getBleName());
            this.addAutoPool(bleDevice);
        }
        this.runOnUiThread(new Runnable((BleDevice)bleDevice){
            final /* synthetic */ BleDevice val$bleDevice;
            {
                this.val$bleDevice = bleDevice;
            }

            @Override
            public void run() {
                if (null != ConnectRequest.this.connectCallback) {
                    ConnectRequest.this.connectCallback.onConnectionChanged(this.val$bleDevice);
                }
                if (ConnectRequest.this.bleWrapperCallback != null) {
                    ConnectRequest.this.bleWrapperCallback.onConnectionChanged(this.val$bleDevice);
                }
            }
        });
    }

    @Override
    public void onConnectException(T bleDevice, int errorCode) {
        if (bleDevice == null) {
            return;
        }
        BleLog.e(TAG, "ConnectException>>>> " + ((BleDevice)bleDevice).getBleName() + "\n\u5f02\u5e38\u7801:" + errorCode);
        this.doConnectException(bleDevice, errorCode);
    }

    @Override
    public void onConnectTimeOut(T bleDevice) {
        if (bleDevice == null) {
            return;
        }
        BleLog.e(TAG, "ConnectTimeOut>>>> " + ((BleDevice)bleDevice).getBleName());
        this.runOnUiThread(new Runnable((BleDevice)bleDevice){
            final /* synthetic */ BleDevice val$bleDevice;
            {
                this.val$bleDevice = bleDevice;
            }

            @Override
            public void run() {
                if (null != ConnectRequest.this.connectCallback) {
                    ConnectRequest.this.connectCallback.onConnectTimeOut(this.val$bleDevice);
                }
            }
        });
        ((BleDevice)bleDevice).setConnectionState(0);
        this.onConnectionChanged(bleDevice);
    }

    @Override
    public void onReady(T bleDevice) {
        if (bleDevice == null) {
            return;
        }
        BleLog.d(TAG, "onReady>>>> " + ((BleDevice)bleDevice).getBleName());
        this.runOnUiThread(new Runnable((BleDevice)bleDevice){
            final /* synthetic */ BleDevice val$bleDevice;
            {
                this.val$bleDevice = bleDevice;
            }

            @Override
            public void run() {
                if (null != ConnectRequest.this.connectCallback) {
                    ConnectRequest.this.connectCallback.onReady(this.val$bleDevice);
                }
                if (ConnectRequest.this.bleWrapperCallback != null) {
                    ConnectRequest.this.bleWrapperCallback.onReady(this.val$bleDevice);
                }
            }
        });
    }

    @Override
    public void onServicesDiscovered(T device, BluetoothGatt gatt) {
        BleLog.d(TAG, "onServicesDiscovered>>>> " + ((BleDevice)device).getBleName());
        if (null != this.connectCallback) {
            this.connectCallback.onServicesDiscovered(device, gatt);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onServicesDiscovered(device, gatt);
        }
    }

    private void addBleToPool(T device) {
        for (BleDevice bleDevice : this.devices) {
            if (!bleDevice.getBleAddress().equals(((BleDevice)device).getBleAddress())) continue;
            BleLog.d(TAG, "addBleToPool>>>> device pool already exist device");
            return;
        }
        this.devices.add(device);
        BleLog.d(TAG, "addBleToPool>>>> added a new device to the device pool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getBleDevice(String address) {
        if (TextUtils.isEmpty((CharSequence)address)) {
            BleLog.e(TAG, "By address to get BleDevice but address is null");
            return null;
        }
        ArrayList<T> arrayList = this.devices;
        synchronized (arrayList) {
            if (this.devices.size() > 0) {
                for (BleDevice bleDevice : this.devices) {
                    if (!bleDevice.getBleAddress().equals(address)) continue;
                    return (T)bleDevice;
                }
            }
            BleLog.e(TAG, "By address to get BleDevice and BleDevice isn't exist");
            return null;
        }
    }

    public ArrayList<T> getConnectedDevices() {
        return this.connectedDevices;
    }

    private void removeAutoPool(BleDevice device) {
        if (device == null) {
            return;
        }
        Iterator<T> iterator = this.autoDevices.iterator();
        while (iterator.hasNext()) {
            BleDevice item = (BleDevice)iterator.next();
            if (!device.getBleAddress().equals(item.getBleAddress())) continue;
            iterator.remove();
        }
    }

    private void addAutoPool(T device) {
        if (device == null) {
            return;
        }
        if (((BleDevice)device).isAutoConnect()) {
            BleLog.d(TAG, "addAutoPool: Add automatic connection device to the connection pool");
            if (!this.autoDevices.contains(device)) {
                this.autoDevices.add(device);
            }
            ConnectQueue.getInstance().put(2000L, RequestTask.newConnectTask(((BleDevice)device).getBleAddress()));
        }
    }

    public void resetReConnect(T device, boolean autoConnect) {
        if (device == null) {
            return;
        }
        ((BleDevice)device).setAutoConnect(autoConnect);
        if (!autoConnect) {
            this.removeAutoPool((BleDevice)device);
            if (((BleDevice)device).isConnecting()) {
                this.disconnect((BleDevice)device);
            }
        } else {
            this.addAutoPool(device);
        }
    }

    public void cancelConnectCallback() {
        this.connectCallback = null;
    }
}

