/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.os.Handler;
import cn.com.heaton.blelibrary.ble.BleHandler;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.exception.AdvertiserUnsupportException;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.utils.ThreadUtils;

@Implement(value=AdvertiserRequest.class)
@TargetApi(value=21)
public class AdvertiserRequest<T extends BleDevice> {
    private static final String TAG = "AdvertiserRequest";
    private Handler mHandler = BleHandler.of();
    private BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private BluetoothLeAdvertiser mAdvertiser;
    private AdvertiseSettings myAdvertiseSettings;
    private AdvertiseData myAdvertiseData;
    private Runnable stopAvertiseRunnable = new Runnable(){

        @Override
        public void run() {
            AdvertiserRequest.this.stopAdvertising();
        }
    };
    @TargetApi(value=21)
    private AdvertiseCallback mAdvertiseCallback = new AdvertiseCallback(){

        public void onStartSuccess(AdvertiseSettings settingsInEffect) {
            super.onStartSuccess(settingsInEffect);
            BleLog.d(AdvertiserRequest.TAG, "onStartSuccess: \u5f00\u542f\u5e7f\u64ad\u6210\u529f");
        }

        public void onStartFailure(int errorCode) {
            super.onStartFailure(errorCode);
            if (errorCode == 1) {
                BleLog.e(AdvertiserRequest.TAG, "Failed to start advertising as the advertise data to be broadcasted is larger than 31 bytes.");
            } else if (errorCode == 2) {
                BleLog.e(AdvertiserRequest.TAG, "Failed to start advertising because no advertising instance is available.");
            } else if (errorCode == 3) {
                BleLog.e(AdvertiserRequest.TAG, "Failed to start advertising as the advertising is already started");
            } else if (errorCode == 4) {
                BleLog.e(AdvertiserRequest.TAG, "Operation failed due to an internal error");
            } else if (errorCode == 5) {
                BleLog.e(AdvertiserRequest.TAG, "This feature is not supported on this platform");
            }
        }
    };

    private void setAdvertiserSettings() {
        this.mAdvertiser = this.bluetoothAdapter.getBluetoothLeAdvertiser();
        if (this.mAdvertiser == null) {
            try {
                throw new AdvertiserUnsupportException("Device does not support Avertise!");
            }
            catch (AdvertiserUnsupportException e) {
                e.printStackTrace();
            }
        }
        this.myAdvertiseSettings = new AdvertiseSettings.Builder().setAdvertiseMode(2).setConnectable(true).setTimeout(0).setTxPowerLevel(3).build();
    }

    public void startAdvertising(final byte[] payload, final AdvertiseSettings advertiseSettings) {
        if (this.bluetoothAdapter.isEnabled()) {
            this.mHandler.removeCallbacks(this.stopAvertiseRunnable);
            if (this.mAdvertiser != null) {
                ThreadUtils.asyn(new Runnable(){

                    @Override
                    public void run() {
                        AdvertiserRequest.this.mAdvertiser.stopAdvertising(AdvertiserRequest.this.mAdvertiseCallback);
                        AdvertiserRequest.this.myAdvertiseData = new AdvertiseData.Builder().addManufacturerData(65520, payload).setIncludeDeviceName(true).build();
                        AdvertiserRequest.this.mAdvertiser.startAdvertising(advertiseSettings, AdvertiserRequest.this.myAdvertiseData, AdvertiserRequest.this.mAdvertiseCallback);
                    }
                });
            }
        }
    }

    public void startAdvertising(byte[] payload) {
        this.setAdvertiserSettings();
        this.startAdvertising(payload, this.myAdvertiseSettings);
    }

    public void stopAdvertising() {
        if (this.bluetoothAdapter.isEnabled() && this.mAdvertiser != null) {
            ThreadUtils.asyn(new Runnable(){

                @Override
                public void run() {
                    BleLog.d(AdvertiserRequest.TAG, "stopAdvertising: \u505c\u6b62\u5e7f\u64ad");
                    AdvertiserRequest.this.mAdvertiser.stopAdvertising(AdvertiserRequest.this.mAdvertiseCallback);
                }
            });
        }
    }

    public void stopAdvertising(Long delay) {
        this.mHandler.postDelayed(this.stopAvertiseRunnable, delay.longValue());
    }
}

