/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.queue;

import cn.com.heaton.blelibrary.ble.queue.RequestTask;
import cn.com.heaton.blelibrary.ble.queue.Task;
import java.util.concurrent.DelayQueue;

abstract class Queue {
    protected DelayQueue<Task> delayQueue = new DelayQueue();
    private long lastTime = 0L;

    protected Queue() {
        DaemonThread daemonTask = new DaemonThread();
        Thread daemonThread = new Thread(daemonTask);
        daemonThread.setName("Connect Daemon");
        daemonThread.start();
    }

    public void put(long time, RequestTask requestTask) {
        this.lastTime += time;
        Task k = new Task(time, this.lastTime, requestTask);
        this.delayQueue.put(k);
    }

    public void remove(Task task) {
        this.delayQueue.remove(task);
    }

    public abstract void execute(RequestTask var1);

    public void clear() {
        this.delayQueue.clear();
        this.lastTime = 0L;
    }

    class DaemonThread
    implements Runnable {
        DaemonThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    RequestTask requestTask;
                    Task task;
                    if ((task = (Task)Queue.this.delayQueue.take()) == null || (requestTask = task.getRequestTask()) == null) {
                        continue;
                    }
                    Queue.this.execute(requestTask);
                    Queue.this.lastTime = Queue.this.lastTime - task.getRealTime();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

