/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.model;

import android.text.TextUtils;
import cn.com.heaton.blelibrary.ble.exception.BleWriteException;

public class EntityData {
    private static final int DEFAULT_LENGTH = 20;
    private boolean autoWriteMode;
    private String address;
    private byte[] data;
    private int packLength = 20;
    private long delay;
    private boolean lastPackComplete;

    public EntityData(boolean autoWriteMode, String address, byte[] data, int packLength, long delay, boolean lastPackComplete) {
        this.autoWriteMode = autoWriteMode;
        this.address = address;
        this.data = data;
        this.packLength = packLength;
        this.delay = delay;
        this.lastPackComplete = lastPackComplete;
    }

    public EntityData(String address, byte[] data, int packLength, long delay, boolean lastPackComplete) {
        this(false, address, data, packLength, delay, false);
    }

    public EntityData(String address, byte[] data, int packLength, long delay) {
        this(false, address, data, packLength, delay, false);
    }

    public EntityData() {
    }

    public EntityData(String address, byte[] data, int packLength) {
        this(false, address, data, packLength, 0L, false);
    }

    public boolean isAutoWriteMode() {
        return this.autoWriteMode;
    }

    public void setAutoWriteMode(boolean autoWriteMode) {
        this.autoWriteMode = autoWriteMode;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = new byte[0];
        }
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getPackLength() {
        return this.packLength;
    }

    public void setPackLength(int packLength) {
        this.packLength = packLength;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isLastPackComplete() {
        return this.lastPackComplete;
    }

    public void setLastPackComplete(boolean lastPackComplete) {
        this.lastPackComplete = lastPackComplete;
    }

    public static void validParms(EntityData entityData) {
        String exception = "";
        if (TextUtils.isEmpty((CharSequence)entityData.address)) {
            exception = "ble address isn't null";
        }
        if (entityData.data == null) {
            exception = "ble data isn't null";
        }
        if (entityData.packLength <= 0) {
            exception = "The data length per packet cannot be less than 0";
        }
        if (!TextUtils.isEmpty((CharSequence)exception)) {
            throw new BleWriteException(exception);
        }
    }

    public static class Builder {
        private boolean autoWriteMode;
        private String address;
        private byte[] data;
        private int packLength = 20;
        private long delay;
        private boolean lastPackComplete;

        public boolean isAutoWriteMode() {
            return this.autoWriteMode;
        }

        public Builder setAutoWriteMode(boolean autoWriteMode) {
            this.autoWriteMode = autoWriteMode;
            return this;
        }

        public String getAddress() {
            return this.address;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        public Builder setData(byte[] data) {
            this.data = data;
            return this;
        }

        public int getPackLength() {
            return this.packLength;
        }

        public Builder setPackLength(int packLength) {
            this.packLength = packLength;
            return this;
        }

        public long getDelay() {
            return this.delay;
        }

        public Builder setDelay(long delay) {
            this.delay = delay;
            return this;
        }

        public boolean isLastPackComplete() {
            return this.lastPackComplete;
        }

        public Builder setLastPackComplete(boolean lastPackComplete) {
            this.lastPackComplete = lastPackComplete;
            return this;
        }

        public EntityData build() {
            return new EntityData(this.autoWriteMode, this.address, this.data, this.packLength, this.delay, this.lastPackComplete);
        }
    }
}

