/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresApi;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.callback.BleConnectCallback;
import cn.com.heaton.blelibrary.ble.callback.BleMtuCallback;
import cn.com.heaton.blelibrary.ble.callback.BleNotifyCallback;
import cn.com.heaton.blelibrary.ble.callback.BleReadCallback;
import cn.com.heaton.blelibrary.ble.callback.BleReadDescCallback;
import cn.com.heaton.blelibrary.ble.callback.BleReadRssiCallback;
import cn.com.heaton.blelibrary.ble.callback.BleScanCallback;
import cn.com.heaton.blelibrary.ble.callback.BleStatusCallback;
import cn.com.heaton.blelibrary.ble.callback.BleWriteCallback;
import cn.com.heaton.blelibrary.ble.callback.BleWriteDescCallback;
import cn.com.heaton.blelibrary.ble.callback.BleWriteEntityCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BluetoothChangedObserver;
import cn.com.heaton.blelibrary.ble.exception.BleException;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.model.BleFactory;
import cn.com.heaton.blelibrary.ble.model.EntityData;
import cn.com.heaton.blelibrary.ble.proxy.RequestImpl;
import cn.com.heaton.blelibrary.ble.proxy.RequestListener;
import cn.com.heaton.blelibrary.ble.proxy.RequestProxy;
import cn.com.heaton.blelibrary.ble.queue.RequestTask;
import cn.com.heaton.blelibrary.ble.queue.WriteQueue;
import cn.com.heaton.blelibrary.ble.request.ConnectRequest;
import cn.com.heaton.blelibrary.ble.request.DescriptorRequest;
import cn.com.heaton.blelibrary.ble.request.Rproxy;
import cn.com.heaton.blelibrary.ble.request.ScanRequest;
import java.util.List;
import java.util.UUID;

public final class Ble<T extends BleDevice> {
    private static final String TAG = "Ble";
    private static volatile Ble sInstance;
    private static volatile Options options;
    private static final long DEFAULT_WRITE_DELAY = 50L;
    private Context context;
    private RequestListener<T> request;
    private final Object locker = new Object();
    private BleRequestImpl bleRequestImpl;
    public static final int REQUEST_ENABLE_BT = 1;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothChangedObserver bleObserver;

    private Ble() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends BleDevice> Ble<T> getInstance() {
        if (sInstance != null) return sInstance;
        Class<Ble> clazz = Ble.class;
        synchronized (Ble.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Ble<T>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void init(Context context, Options options, InitCallback callback) {
        if (context == null) {
            throw new BleException("context is null");
        }
        if (this.context != null) {
            BleLog.e(TAG, "Ble is Initialized!");
            if (callback != null) {
                callback.failed(2001);
            }
            return;
        }
        this.context = context;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            if (callback != null) {
                BleLog.e(TAG, "bluetoothAdapter is not available!");
                callback.failed(2007);
            }
            return;
        }
        if (!this.isSupportBle(context)) {
            if (callback != null) {
                BleLog.e(TAG, "not support ble!");
                callback.failed(2005);
            }
            return;
        }
        Ble.options = options == null ? Ble.options() : options;
        BleLog.init(Ble.options);
        this.request = (RequestListener)RequestProxy.newProxy().bindProxy(context, RequestImpl.newRequestImpl());
        this.bleRequestImpl = BleRequestImpl.getBleRequest();
        this.bleRequestImpl.initialize(context);
        this.initBleObserver();
        BleLog.d(TAG, "Ble init success");
        if (callback != null) {
            callback.success();
        }
    }

    public static <T extends BleDevice> Ble<T> create(Context context, InitCallback callback) {
        return Ble.create(context, Ble.options(), callback);
    }

    public static <T extends BleDevice> Ble<T> create(Context context, Options options, InitCallback callback) {
        Ble<T> ble = Ble.getInstance();
        ble.init(context, options, callback);
        return ble;
    }

    public void setBleStatusCallback(BleStatusCallback callback) {
        if (this.bleObserver != null) {
            this.bleObserver.setBleScanCallbackInner(callback);
        }
    }

    public void startScan(BleScanCallback<T> callback) {
        this.request.startScan(callback, Ble.options().scanPeriod);
    }

    public void startScan(BleScanCallback<T> callback, long scanPeriod) {
        this.request.startScan(callback, scanPeriod);
    }

    public void stopScan() {
        this.request.stopScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(T device, BleConnectCallback<T> callback) {
        Object object = this.locker;
        synchronized (object) {
            this.request.connect(device, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String address, BleConnectCallback<T> callback) {
        Object object = this.locker;
        synchronized (object) {
            this.request.connect(address, callback);
        }
    }

    public void connects(List<T> devices, BleConnectCallback<T> callback) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        request.connect(devices, callback);
    }

    public void cancelConnecting(T device) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        request.cancelConnecting(device);
    }

    public void cancelConnectings(List<T> devices) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        request.cancelConnectings(devices);
    }

    public void autoConnect(T device, boolean autoConnect) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        request.resetReConnect(device, autoConnect);
    }

    public void disconnect(T device) {
        this.request.disconnect(device);
    }

    public void disconnect(T device, BleConnectCallback<T> callback) {
        this.request.disconnect(device, callback);
    }

    public void disconnectAll() {
        List<T> connectedDevices = this.getConnectedDevices();
        if (!connectedDevices.isEmpty()) {
            for (BleDevice device : connectedDevices) {
                this.request.disconnect(device);
            }
        }
    }

    public void startNotify(T device, BleNotifyCallback<T> callback) {
        this.request.notify(device, callback);
    }

    public void cancelNotify(T device, BleNotifyCallback<T> callback) {
        this.request.cancelNotify(device, callback);
    }

    public void enableNotify(T device, boolean enable, BleNotifyCallback<T> callback) {
        this.request.enableNotify(device, enable, callback);
    }

    public void enableNotifyByUuid(T device, boolean enable, UUID serviceUUID, UUID characteristicUUID, BleNotifyCallback<T> callback) {
        this.request.enableNotifyByUuid(device, enable, serviceUUID, characteristicUUID, callback);
    }

    public boolean read(T device, BleReadCallback<T> callback) {
        return this.request.read(device, callback);
    }

    public boolean readByUuid(T device, UUID serviceUUID, UUID characteristicUUID, BleReadCallback<T> callback) {
        return this.request.readByUuid(device, serviceUUID, characteristicUUID, callback);
    }

    public boolean readDesByUuid(T device, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID, BleReadDescCallback<T> callback) {
        DescriptorRequest request = (DescriptorRequest)Rproxy.getRequest(DescriptorRequest.class);
        return request.readDes(device, serviceUUID, characteristicUUID, descriptorUUID, callback);
    }

    public boolean writeDesByUuid(T device, byte[] data, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID, BleWriteDescCallback<T> callback) {
        DescriptorRequest request = (DescriptorRequest)Rproxy.getRequest(DescriptorRequest.class);
        return request.writeDes(device, data, serviceUUID, characteristicUUID, descriptorUUID, callback);
    }

    public boolean readRssi(T device, BleReadRssiCallback<T> callback) {
        return this.request.readRssi(device, callback);
    }

    public boolean setMTU(String address, int mtu, BleMtuCallback<T> callback) {
        return this.request.setMtu(address, mtu, callback);
    }

    public boolean write(T device, byte[] data, BleWriteCallback<T> callback) {
        return this.request.write(device, data, callback);
    }

    public boolean writeByUuid(T device, byte[] data, UUID serviceUUID, UUID characteristicUUID, BleWriteCallback<T> callback) {
        return this.request.writeByUuid(device, data, serviceUUID, characteristicUUID, callback);
    }

    public void writeQueueDelay(long delay, RequestTask task) {
        WriteQueue.getInstance().put(delay, task);
    }

    public void writeQueue(RequestTask task) {
        this.writeQueueDelay(50L, task);
    }

    public void writeEntity(T device, byte[] data, @IntRange(from=1L, to=20L) int packLength, int delay, BleWriteEntityCallback<T> callback) {
        this.request.writeEntity(device, data, packLength, delay, callback);
    }

    public void writeEntity(EntityData entityData, BleWriteEntityCallback<T> callback) {
        this.request.writeEntity(entityData, callback);
    }

    public void cancelWriteEntity() {
        this.request.cancelWriteEntity();
    }

    public BleRequestImpl getBleRequest() {
        return this.bleRequestImpl;
    }

    public T getBleDevice(String address) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        return request.getBleDevice(address);
    }

    public T getBleDevice(BluetoothDevice device) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        if (device != null) {
            return request.getBleDevice(device.getAddress());
        }
        return null;
    }

    public Object getLocker() {
        return this.locker;
    }

    public boolean isScanning() {
        ScanRequest request = (ScanRequest)Rproxy.getRequest(ScanRequest.class);
        return request.isScanning();
    }

    public List<T> getConnectedDevices() {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        return request.getConnectedDevices();
    }

    public void released() {
        this.releaseGatts();
        this.releaseBleObserver();
        if (this.isScanning()) {
            this.stopScan();
        }
        this.bleRequestImpl.release();
        this.bleRequestImpl = null;
        Rproxy.release();
        this.context = null;
        BleLog.d(TAG, "AndroidBLE already released");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGatts() {
        BleLog.d(TAG, "BluetoothGatts is released");
        Object object = this.locker;
        synchronized (object) {
            List<T> connetedDevices = this.getConnectedDevices();
            for (BleDevice bleDevice : connetedDevices) {
                this.disconnect(bleDevice);
            }
        }
    }

    private void initBleObserver() {
        if (this.bleObserver == null) {
            this.bleObserver = new BluetoothChangedObserver(this.context);
            this.bleObserver.registerReceiver();
        }
    }

    private void releaseBleObserver() {
        BleLog.d(TAG, "BleObserver is released");
        if (this.bleObserver != null) {
            this.bleObserver.unregisterReceiver();
            this.bleObserver = null;
        }
    }

    public void cancelCallback(Object callback) {
        if (callback instanceof BleScanCallback) {
            ScanRequest request = (ScanRequest)Rproxy.getRequest(ScanRequest.class);
            request.cancelScanCallback();
        } else if (callback instanceof BleConnectCallback) {
            ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
            request.cancelConnectCallback();
        }
    }

    private BluetoothAdapter getBluetoothAdapter() {
        if (this.bluetoothAdapter == null) {
            this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return this.bluetoothAdapter;
    }

    public boolean isSupportBle(Context context) {
        return this.getBluetoothAdapter() != null && context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public boolean isBleEnable() {
        BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
        return bluetoothAdapter != null && bluetoothAdapter.isEnabled();
    }

    public void turnOnBlueTooth(Activity activity) {
        if (!this.isBleEnable()) {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            activity.startActivityForResult(enableBtIntent, 1);
        }
    }

    public void turnOnBlueToothNo() {
        if (!this.isBleEnable() && this.bluetoothAdapter != null) {
            this.bluetoothAdapter.enable();
        }
    }

    public boolean turnOffBlueTooth() {
        if (this.isBleEnable()) {
            return this.bluetoothAdapter.disable();
        }
        return true;
    }

    public boolean refreshDeviceCache(String address) {
        if (this.bleRequestImpl != null) {
            return this.bleRequestImpl.refreshDeviceCache(address);
        }
        return false;
    }

    public static Options options() {
        if (options == null) {
            options = new Options();
        }
        return options;
    }

    public Context getContext() {
        return this.context;
    }

    public static class Options {
        public boolean logBleEnable = true;
        public String logTAG = "AndroidBLE";
        public boolean throwBleException = true;
        public boolean autoConnect = false;
        public long connectTimeout = 10000L;
        public long scanPeriod = 10000L;
        public int serviceBindFailedRetryCount = 3;
        public int connectFailedRetryCount;
        public int maxConnectNum = 7;
        public boolean isIgnoreRepeat = false;
        public ScanFilter scanFilter;
        public boolean isParseScanData = false;
        @RequiresApi(api=21)
        public int manufacturerId = 65520;
        public BleWrapperCallback bleWrapperCallback;
        private BleFactory factory;
        UUID[] uuid_services_extra = new UUID[0];
        UUID uuid_service = UUID.fromString("0000fee9-0000-1000-8000-00805f9b34fb");
        UUID uuid_write_cha = UUID.fromString("d44bc439-abfd-45a2-b575-925416129600");
        UUID uuid_read_cha = UUID.fromString("d44bc439-abfd-45a2-b575-925416129600");
        UUID uuid_notify_cha = UUID.fromString("d44bc439-abfd-45a2-b575-925416129601");
        UUID uuid_notify_desc = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
        UUID uuid_ota_service = UUID.fromString("0000fee8-0000-1000-8000-00805f9b34fb");
        UUID uuid_ota_notify_cha = UUID.fromString("003784cf-f7e3-55b4-6c4c-9fd140100a16");
        UUID uuid_ota_write_cha = UUID.fromString("013784cf-f7e3-55b4-6c4c-9fd140100a16");

        public Options setScanPeriod(long scanPeriod) {
            this.scanPeriod = scanPeriod;
            return this;
        }

        public String getLogTAG() {
            return this.logTAG;
        }

        public Options setLogTAG(String logTAG) {
            this.logTAG = logTAG;
            return this;
        }

        public boolean isLogBleEnable() {
            return this.logBleEnable;
        }

        public Options setLogBleEnable(boolean logBleEnable) {
            this.logBleEnable = logBleEnable;
            return this;
        }

        public boolean isThrowBleException() {
            return this.throwBleException;
        }

        public Options setThrowBleException(boolean throwBleException) {
            this.throwBleException = throwBleException;
            return this;
        }

        public boolean isAutoConnect() {
            return this.autoConnect;
        }

        public Options setAutoConnect(boolean autoConnect) {
            this.autoConnect = autoConnect;
            return this;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }

        public Options setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public long getScanPeriod() {
            return this.scanPeriod;
        }

        public int getServiceBindFailedRetryCount() {
            return this.serviceBindFailedRetryCount;
        }

        public Options setServiceBindFailedRetryCount(int serviceBindFailedRetryCount) {
            this.serviceBindFailedRetryCount = serviceBindFailedRetryCount;
            return this;
        }

        public int getConnectFailedRetryCount() {
            return this.connectFailedRetryCount;
        }

        public Options setConnectFailedRetryCount(@IntRange(from=0L, to=5L) int connectFailedRetryCount) {
            this.connectFailedRetryCount = connectFailedRetryCount;
            return this;
        }

        public int getMaxConnectNum() {
            return this.maxConnectNum;
        }

        public Options setMaxConnectNum(@IntRange(from=1L, to=7L) int maxConnectNum) {
            this.maxConnectNum = maxConnectNum;
            return this;
        }

        public boolean isIgnoreRepeat() {
            return this.isIgnoreRepeat;
        }

        public Options setIgnoreRepeat(boolean ignoreRepeat) {
            this.isIgnoreRepeat = ignoreRepeat;
            return this;
        }

        public ScanFilter getScanFilter() {
            return this.scanFilter;
        }

        public Options setScanFilter(ScanFilter scanFilter) {
            this.scanFilter = scanFilter;
            return this;
        }

        public boolean isParseScanData() {
            return this.isParseScanData;
        }

        public Options setParseScanData(boolean parseScanData) {
            this.isParseScanData = parseScanData;
            return this;
        }

        @RequiresApi(api=21)
        public int getManufacturerId() {
            return this.manufacturerId;
        }

        @RequiresApi(api=21)
        public Options setManufacturerId(int manufacturerId) {
            this.manufacturerId = manufacturerId;
            return this;
        }

        public BleWrapperCallback getBleWrapperCallback() {
            return this.bleWrapperCallback;
        }

        public Options setBleWrapperCallback(BleWrapperCallback bleWrapperCallback) {
            this.bleWrapperCallback = bleWrapperCallback;
            return this;
        }

        public BleFactory getFactory() {
            if (this.factory == null) {
                this.factory = new BleFactory(){

                    public BleDevice create(String address, String name) {
                        return super.create(address, name);
                    }
                };
            }
            return this.factory;
        }

        public Options setFactory(BleFactory factory) {
            this.factory = factory;
            return this;
        }

        public UUID[] getUuidServicesExtra() {
            return this.uuid_services_extra;
        }

        public Options setUuidServicesExtra(UUID[] uuid_services_extra) {
            this.uuid_services_extra = uuid_services_extra;
            return this;
        }

        public UUID getUuidService() {
            return this.uuid_service;
        }

        public Options setUuidService(UUID uuid_service) {
            this.uuid_service = uuid_service;
            return this;
        }

        public UUID getUuidWriteCha() {
            return this.uuid_write_cha;
        }

        public Options setUuidWriteCha(UUID uuid_write_cha) {
            this.uuid_write_cha = uuid_write_cha;
            return this;
        }

        public UUID getUuidReadCha() {
            return this.uuid_read_cha;
        }

        public Options setUuidReadCha(UUID uuid_read_cha) {
            this.uuid_read_cha = uuid_read_cha;
            return this;
        }

        public UUID getUuidNotifyCha() {
            return this.uuid_notify_cha;
        }

        public Options setUuidNotifyCha(UUID uuid_notify_cha) {
            this.uuid_notify_cha = uuid_notify_cha;
            return this;
        }

        public UUID getUuidNotifyDesc() {
            return this.uuid_notify_desc;
        }

        public Options setUuidNotifyDesc(UUID uuid_notify_desc) {
            this.uuid_notify_desc = uuid_notify_desc;
            return this;
        }

        public UUID getUuidOtaService() {
            return this.uuid_ota_service;
        }

        public Options setUuidOtaService(UUID uuid_ota_service) {
            this.uuid_ota_service = uuid_ota_service;
            return this;
        }

        public UUID getUuidOtaNotifyCha() {
            return this.uuid_ota_notify_cha;
        }

        public Options setUuidOtaNotifyCha(UUID uuid_ota_notify_cha) {
            this.uuid_ota_notify_cha = uuid_ota_notify_cha;
            return this;
        }

        public UUID getUuidOtaWriteCha() {
            return this.uuid_ota_write_cha;
        }

        public Options setUuidOtaWriteCha(UUID uuid_ota_write_cha) {
            this.uuid_ota_write_cha = uuid_ota_write_cha;
            return this;
        }

        public <T extends BleDevice> Ble<T> create(Context context) {
            return this.create(context, null);
        }

        public <T extends BleDevice> Ble<T> create(Context context, InitCallback callback) {
            return Ble.create(context, callback);
        }
    }

    public static interface InitCallback {
        public void success();

        public void failed(int var1);
    }
}

