/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.shadow;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;

class ShadowView
extends View {
    final Paint mPaint = new Paint(1);
    int shadowColor;
    float shadowRadius;
    float dx;
    float dy;
    float bgRadius;
    int bgColor;
    RectF rect = new RectF();

    public ShadowView(Context context) {
        this(context, null);
    }

    public ShadowView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        if (this.isInEditMode()) {
            this.shadowRadius = 10.0f;
            this.shadowColor = -16777216;
            this.bgColor = -1;
            this.dx = 6.0f;
            this.dy = 6.0f;
            this.bgRadius = 10.0f;
            this.mPaint.setColor(this.bgColor);
        }
    }

    protected void onDraw(Canvas canvas) {
        boolean shadow = this.shadowRadius > 0.0f;
        this.rect.left = this.shadowRadius;
        this.rect.top = this.shadowRadius;
        this.rect.right = (float)this.getWidth() - this.shadowRadius;
        this.rect.bottom = (float)this.getHeight() - this.shadowRadius;
        if (shadow) {
            this.mPaint.setShadowLayer(this.shadowRadius, this.dx, this.dy, this.shadowColor);
        }
        canvas.drawRoundRect(this.rect, this.bgRadius, this.bgRadius, this.mPaint);
        if (shadow) {
            this.mPaint.clearShadowLayer();
        }
    }
}

