/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.util.Pools;

public class ViewHelper {
    private static final ThreadLocal<Matrix> sMatrix = new ThreadLocal();
    private static final ThreadLocal<RectF> sRectF = new ThreadLocal();
    private static final Pools.Pool<Rect> sRectPool = new Pools.SynchronizedPool(12);
    private static boolean INIT = false;
    private static int STATUS_BAR_HEIGHT = 50;
    private static final String STATUS_BAR_DEF_PACKAGE = "android";
    private static final String STATUS_BAR_DEF_TYPE = "dimen";
    private static final String STATUS_BAR_NAME = "status_bar_height";

    static void offsetDescendantRect(ViewGroup parent, View descendant, Rect rect) {
        Matrix m = sMatrix.get();
        if (m == null) {
            m = new Matrix();
            sMatrix.set(m);
        } else {
            m.reset();
        }
        ViewHelper.offsetDescendantMatrix((ViewParent)parent, descendant, m);
        RectF rectF = sRectF.get();
        if (rectF == null) {
            rectF = new RectF();
            sRectF.set(rectF);
        }
        rectF.set(rect);
        m.mapRect(rectF);
        rect.set((int)(rectF.left + 0.5f), (int)(rectF.top + 0.5f), (int)(rectF.right + 0.5f), (int)(rectF.bottom + 0.5f));
    }

    public static void getDescendantRect(ViewGroup parent, View descendant, Rect out) {
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        ViewHelper.offsetDescendantRect(parent, descendant, out);
    }

    private static void offsetDescendantMatrix(ViewParent target, View view, Matrix m) {
        ViewParent parent = view.getParent();
        if (parent instanceof View && parent != target) {
            View vp = (View)parent;
            ViewHelper.offsetDescendantMatrix(target, vp, m);
            m.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
        }
        m.preTranslate((float)view.getLeft(), (float)view.getTop());
        if (!view.getMatrix().isIdentity()) {
            m.preConcat(view.getMatrix());
        }
    }

    @NonNull
    private static Rect acquireTempRect() {
        Rect rect = (Rect)sRectPool.acquire();
        if (rect == null) {
            rect = new Rect();
        }
        return rect;
    }

    private static void releaseTempRect(@NonNull Rect rect) {
        rect.setEmpty();
        sRectPool.release((Object)rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPointInChildBounds(ViewGroup parent, @NonNull View child, int x, int y) {
        Rect r = ViewHelper.acquireTempRect();
        ViewHelper.getDescendantRect(parent, child, r);
        try {
            boolean bl = r.contains(x, y);
            return bl;
        }
        finally {
            ViewHelper.releaseTempRect(r);
        }
    }

    @Nullable
    public static ColorStateList getColorStateList(@NonNull Context context, @NonNull TypedArray attributes, @StyleableRes int index) {
        int color;
        ColorStateList value;
        int resourceId;
        if (attributes.hasValue(index) && (resourceId = attributes.getResourceId(index, 0)) != 0 && (value = AppCompatResources.getColorStateList((Context)context, (int)resourceId)) != null) {
            return value;
        }
        if (Build.VERSION.SDK_INT <= 15 && (color = attributes.getColor(index, -1)) != -1) {
            return ColorStateList.valueOf((int)color);
        }
        return attributes.getColorStateList(index);
    }

    public static synchronized int getStatusBarHeight(Context context) {
        int resourceId;
        if (!INIT && (resourceId = context.getResources().getIdentifier(STATUS_BAR_NAME, STATUS_BAR_DEF_TYPE, STATUS_BAR_DEF_PACKAGE)) > 0) {
            STATUS_BAR_HEIGHT = context.getResources().getDimensionPixelSize(resourceId);
            INIT = true;
        }
        return STATUS_BAR_HEIGHT;
    }

    public static void transparentStatusBar(@NonNull Activity activity) {
        Window window = activity.getWindow();
        View decorView = window.getDecorView();
        decorView.setSystemUiVisibility(1280);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
    }
}

