/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.lyric;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Region;
import android.graphics.SurfaceTexture;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.TextureView;
import cn.com.lasong.widget.lyric.ITimeProvider;
import cn.com.lasong.widget.lyric.Lyric;
import cn.com.lasong.widget.lyric.LyricLine;
import cn.com.lasong.widget.lyric.LyricUtils;
import cn.com.lasong.widget.lyric.LyricWord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;

public class LrcView
extends TextureView
implements TextureView.SurfaceTextureListener,
ITimeProvider,
Runnable {
    private boolean mDestroy = false;
    private final Object mFence = new Object();
    private Thread mThread;
    private Paint mPaint = new Paint(1);
    private final int DEFAULT_TEXT_SIZE_PX = this.sp2px(16.0f);
    private final int PLAYING_TEXT_SIZE_PX = this.sp2px(18.0f);
    private final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#99FFFFFF");
    private final int PLAYING_DEFAULT_TEXT_COLOR = -1;
    private final int PLAYING_PASS_TEXT_COLOR = Color.parseColor((String)"#FF479A");
    private final int ROW = 3;
    private ITimeProvider mProvider;
    private Lyric mLrc;
    private long mStartRenderTs;
    private float mWidth;
    private float mHeight;

    public LrcView(Context context) {
        this(context, null);
    }

    public LrcView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LrcView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOpaque(false);
        this.setSurfaceTextureListener(this);
        this.mPaint.setTextSize((float)this.DEFAULT_TEXT_SIZE_PX);
        this.mPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setColor(this.DEFAULT_TEXT_COLOR);
        this.mThread = new Thread((Runnable)this, "LrcView");
        this.mThread.start();
    }

    int sp2px(float spValue) {
        float fontScale = Resources.getSystem().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mDestroy = false;
        Canvas canvas = this.lockCanvas();
        if (null != canvas) {
            this.mPaint.setTextSize((float)this.DEFAULT_TEXT_SIZE_PX);
            this.mPaint.setColor(this.DEFAULT_TEXT_COLOR);
            Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
            float centerY = this.mHeight / 2.0f;
            float centerX = this.mWidth / 2.0f;
            int baselineY = (int)(centerY - (fontMetrics.top + fontMetrics.bottom) / 2.0f);
            canvas.drawText("Waiting For You!", centerX, (float)baselineY, this.mPaint);
            canvas.drawColor(0);
        }
        this.unlockCanvasAndPost(canvas);
        Object object = this.mFence;
        synchronized (object) {
            this.mFence.notifyAll();
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mDestroy = true;
        Object object = this.mFence;
        synchronized (object) {
            this.mFence.notifyAll();
        }
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mDestroy = true;
        Object object = this.mFence;
        synchronized (object) {
            this.mFence.notifyAll();
        }
    }

    public void setProvider(ITimeProvider provider) {
        this.mProvider = provider;
    }

    public boolean showLyric(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.showLyric(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean showLyric(InputStream in) {
        Lyric lrc = LyricUtils.readLyric(in);
        return this.showLyric(lrc);
    }

    public boolean showLyric(Lyric lrc) {
        if (null == lrc) {
            return false;
        }
        this.mLrc = lrc;
        this.mStartRenderTs = System.currentTimeMillis();
        this.setVisibility(0);
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            Object object = this.mFence;
            synchronized (object) {
                this.mFence.notifyAll();
            }
        }
    }

    private boolean isBlock() {
        boolean isUnAvailable = !this.isAvailable();
        boolean isUnVisible = this.getVisibility() != 0;
        boolean isInValidLrc = this.mLrc == null || null == this.mLrc.lines || this.mLrc.lines.size() == 0;
        boolean isPlayEnd = null != this.mLrc && this.getCurrentPosition() > this.mLrc.total;
        return isUnAvailable || isUnVisible || isInValidLrc || isPlayEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.mDestroy) {
            float percent;
            if (this.isBlock()) {
                Object object = this.mFence;
                synchronized (object) {
                    try {
                        this.mFence.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            List<LyricLine> lines = this.mLrc.lines;
            if (null == lines || lines.size() <= 0) continue;
            long passMs = this.getCurrentPosition();
            int lineSize = lines.size();
            int current = 0;
            long offset = null != this.mLrc ? this.mLrc.offset : 0L;
            for (int i = 0; i < lineSize; ++i) {
                LyricLine line = lines.get(i);
                long start = line.start + offset;
                long end = start + line.duration;
                if (passMs >= start) {
                    current = i;
                }
                if (passMs < start) break;
            }
            int centerLine = 1;
            LyricLine curLrc = lines.get(current);
            LyricLine[] lrcArray = new LyricLine[3];
            for (int i = 0; i < 3; ++i) {
                int lrcOffset = centerLine - i;
                lrcArray[i] = lrcOffset >= 0 ? (current - lrcOffset >= 0 ? lines.get(current - lrcOffset) : null) : (current - lrcOffset < lineSize ? lines.get(current - lrcOffset) : null);
            }
            long linePassMs = passMs - (curLrc.start + offset);
            if (linePassMs < 0L || linePassMs > curLrc.duration) {
                linePassMs = linePassMs < 0L ? 0L : curLrc.duration;
                percent = linePassMs <= 0L ? 0.0f : 1.0f;
            } else {
                List<LyricWord> words = curLrc.words;
                int wordSize = null != words ? words.size() : 0;
                float passWords = 0.0f;
                for (int i = 0; i < wordSize; ++i) {
                    LyricWord word = words.get(i);
                    if (word.start + word.duration <= linePassMs) {
                        passWords += 1.0f;
                        continue;
                    }
                    if (linePassMs < word.start) continue;
                    passWords += (float)(linePassMs - word.start) * 1.0f / (float)word.duration;
                    break;
                }
                percent = wordSize > 0 ? passWords / (float)wordSize : 0.0f;
            }
            Canvas canvas = this.lockCanvas();
            Object wordSize = this.mFence;
            synchronized (wordSize) {
                if (this.mDestroy) {
                    break;
                }
            }
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            float centerX = this.mWidth / 2.0f;
            float lineHeight = this.mHeight / 3.0f;
            float centerY = lineHeight / 2.0f;
            for (int i = 0; i < 3; ++i) {
                String text;
                String string2 = text = lrcArray[i] != null ? lrcArray[i].content : "";
                if (centerLine == i) {
                    this.mPaint.setTextSize((float)this.PLAYING_TEXT_SIZE_PX);
                    this.mPaint.setColor(-1);
                } else {
                    this.mPaint.setTextSize((float)this.DEFAULT_TEXT_SIZE_PX);
                    this.mPaint.setColor(this.DEFAULT_TEXT_COLOR);
                }
                Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
                int baselineY = (int)(centerY - (fontMetrics.top + fontMetrics.bottom) / 2.0f);
                canvas.drawText(text, centerX, (float)baselineY, this.mPaint);
                if (centerLine == i) {
                    float textWidth = this.mPaint.measureText(text, 0, text.length());
                    float textTop = centerY - lineHeight / 2.0f;
                    float textBottom = centerY + lineHeight / 2.0f;
                    float textLeft = (this.mWidth - textWidth) / 2.0f;
                    canvas.save();
                    canvas.clipRect(textLeft, textTop, textLeft + textWidth, textBottom);
                    canvas.clipRect(textLeft, textTop, textLeft + textWidth * percent, textBottom, Region.Op.INTERSECT);
                    this.mPaint.setColor(this.PLAYING_PASS_TEXT_COLOR);
                    canvas.drawText(text, centerX, (float)baselineY, this.mPaint);
                    canvas.restore();
                }
                centerY += lineHeight;
            }
            this.unlockCanvasAndPost(canvas);
            try {
                Thread.sleep(this.getPollingInterval());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void hideLrc() {
        this.setVisibility(8);
    }

    @Override
    public long getCurrentPosition() {
        if (null != this.mProvider) {
            return this.mProvider.getCurrentPosition();
        }
        return System.currentTimeMillis() - this.mStartRenderTs;
    }

    @Override
    public long getPollingInterval() {
        if (null != this.mProvider) {
            return this.mProvider.getPollingInterval();
        }
        return 50L;
    }
}

