/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.loadmore;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class ReachEndListener
extends RecyclerView.OnScrollListener {
    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        int lastPosition = -1;
        if (newState == 0 && null != recyclerView.getLayoutManager()) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                lastPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof LinearLayoutManager) {
                lastPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] lastPositions = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(lastPositions);
                lastPosition = this.findMax(lastPositions);
            }
            if (lastPosition == layoutManager.getItemCount() - 1) {
                this.onReachBottom();
            }
        } else if (newState == 1) {
            this.onDragging();
        }
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
    }

    protected void onReachBottom() {
    }

    protected void onDragging() {
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }
}

