/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.aigestudio.datepicker.bizs.decors.DPDecor;
import cn.aigestudio.datepicker.bizs.languages.DPLManager;
import cn.aigestudio.datepicker.bizs.themes.DPTManager;
import cn.aigestudio.datepicker.cons.DPMode;
import cn.aigestudio.datepicker.utils.MeasureUtil;
import cn.aigestudio.datepicker.views.MonthView;
import java.util.List;

public class DatePicker
extends LinearLayout {
    private DPTManager mTManager = DPTManager.getInstance();
    private DPLManager mLManager = DPLManager.getInstance();
    private MonthView monthView;
    private TextView tvYear;
    private TextView tvMonth;
    private TextView tvEnsure;
    private OnDateSelectedListener onDateSelectedListener;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        LinearLayout.LayoutParams llParams = new LinearLayout.LayoutParams(-1, -2);
        RelativeLayout rlTitle = new RelativeLayout(context);
        rlTitle.setBackgroundColor(this.mTManager.colorTitleBG());
        int rlTitlePadding = MeasureUtil.dp2px(context, 10.0f);
        rlTitle.setPadding(rlTitlePadding, rlTitlePadding, rlTitlePadding, rlTitlePadding);
        LinearLayout llWeek = new LinearLayout(context);
        llWeek.setBackgroundColor(this.mTManager.colorTitleBG());
        llWeek.setOrientation(0);
        int llWeekPadding = MeasureUtil.dp2px(context, 5.0f);
        llWeek.setPadding(0, llWeekPadding, 0, llWeekPadding);
        LinearLayout.LayoutParams lpWeek = new LinearLayout.LayoutParams(-2, -2);
        lpWeek.weight = 1.0f;
        RelativeLayout.LayoutParams lpYear = new RelativeLayout.LayoutParams(-2, -2);
        lpYear.addRule(15);
        RelativeLayout.LayoutParams lpMonth = new RelativeLayout.LayoutParams(-2, -2);
        lpMonth.addRule(13);
        RelativeLayout.LayoutParams lpEnsure = new RelativeLayout.LayoutParams(-2, -2);
        lpEnsure.addRule(15);
        lpEnsure.addRule(11);
        this.tvYear = new TextView(context);
        this.tvYear.setText((CharSequence)"2015");
        this.tvYear.setTextSize(1, 16.0f);
        this.tvYear.setTextColor(this.mTManager.colorTitle());
        this.tvMonth = new TextView(context);
        this.tvMonth.setText((CharSequence)"\u516d\u6708");
        this.tvMonth.setTextSize(1, 20.0f);
        this.tvMonth.setTextColor(this.mTManager.colorTitle());
        this.tvEnsure = new TextView(context);
        this.tvEnsure.setText((CharSequence)this.mLManager.titleEnsure());
        this.tvEnsure.setTextSize(1, 16.0f);
        this.tvEnsure.setTextColor(this.mTManager.colorTitle());
        this.tvEnsure.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != DatePicker.this.onDateSelectedListener) {
                    DatePicker.this.onDateSelectedListener.onDateSelected(DatePicker.this.monthView.getDateSelected());
                }
            }
        });
        rlTitle.addView((View)this.tvYear, (ViewGroup.LayoutParams)lpYear);
        rlTitle.addView((View)this.tvMonth, (ViewGroup.LayoutParams)lpMonth);
        rlTitle.addView((View)this.tvEnsure, (ViewGroup.LayoutParams)lpEnsure);
        this.addView((View)rlTitle, (ViewGroup.LayoutParams)llParams);
        for (int i = 0; i < this.mLManager.titleWeek().length; ++i) {
            TextView tvWeek = new TextView(context);
            tvWeek.setText((CharSequence)this.mLManager.titleWeek()[i]);
            tvWeek.setGravity(17);
            tvWeek.setTextSize(1, 14.0f);
            tvWeek.setTextColor(this.mTManager.colorTitle());
            llWeek.addView((View)tvWeek, (ViewGroup.LayoutParams)lpWeek);
        }
        this.addView((View)llWeek, (ViewGroup.LayoutParams)llParams);
        this.monthView = new MonthView(context);
        this.monthView.setOnDateChangeListener(new MonthView.OnDateChangeListener(){

            @Override
            public void onMonthChange(int month) {
                DatePicker.this.tvMonth.setText((CharSequence)DatePicker.this.mLManager.titleMonth()[month - 1]);
            }

            @Override
            public void onYearChange(int year) {
                String tmp = String.valueOf(year);
                if (tmp.startsWith("-")) {
                    tmp = tmp.replace("-", DatePicker.this.mLManager.titleBC());
                }
                DatePicker.this.tvYear.setText((CharSequence)tmp);
            }
        });
        this.addView(this.monthView, (ViewGroup.LayoutParams)llParams);
    }

    public void setDate(int year, int month) {
        if (month < 1) {
            month = 1;
        }
        if (month > 12) {
            month = 12;
        }
        this.monthView.setDate(year, month);
    }

    public void setDPDecor(DPDecor decor) {
        this.monthView.setDPDecor(decor);
    }

    public void setMode(DPMode mode) {
        if (mode != DPMode.MULTIPLE) {
            this.tvEnsure.setVisibility(8);
        }
        this.monthView.setDPMode(mode);
    }

    public void setFestivalDisplay(boolean isFestivalDisplay) {
        this.monthView.setFestivalDisplay(isFestivalDisplay);
    }

    public void setTodayDisplay(boolean isTodayDisplay) {
        this.monthView.setTodayDisplay(isTodayDisplay);
    }

    public void setHolidayDisplay(boolean isHolidayDisplay) {
        this.monthView.setHolidayDisplay(isHolidayDisplay);
    }

    public void setDeferredDisplay(boolean isDeferredDisplay) {
        this.monthView.setDeferredDisplay(isDeferredDisplay);
    }

    public void setOnDatePickedListener(OnDatePickedListener onDatePickedListener) {
        if (this.monthView.getDPMode() != DPMode.SINGLE) {
            throw new RuntimeException("Current DPMode does not SINGLE! Please call setMode set DPMode to SINGLE!");
        }
        this.monthView.setOnDatePickedListener(onDatePickedListener);
    }

    public void setOnDateSelectedListener(OnDateSelectedListener onDateSelectedListener) {
        if (this.monthView.getDPMode() != DPMode.MULTIPLE) {
            throw new RuntimeException("Current DPMode does not MULTIPLE! Please call setMode set DPMode to MULTIPLE!");
        }
        this.onDateSelectedListener = onDateSelectedListener;
    }

    public static interface OnDateSelectedListener {
        public void onDateSelected(List<String> var1);
    }

    public static interface OnDatePickedListener {
        public void onDatePicked(String var1);
    }
}

