/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.bizs.calendars;

import android.text.TextUtils;
import cn.aigestudio.datepicker.bizs.calendars.DPCalendar;
import cn.aigestudio.datepicker.bizs.calendars.SolarTerm;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DPCNCalendar
extends DPCalendar {
    private static final int[] FIRST_DAY_OF_LUNAR_IN_GREGORIAN = new int[]{1897, 30122, 5482, 67949, 2396, 5294, 43597, 6732, 6954, 36181, 2772, 4954, 18781, 2396, 54427, 5274, 6730, 47781, 5800, 6868, 21210, 4790, 59703, 2350, 5270, 46667, 3402, 3496, 38325, 1388, 4782, 18735, 2350, 52374, 6804, 7498, 44457, 2906, 1388, 29294, 4700, 63789, 6442, 6804, 56138, 5802, 2772, 38235, 1210, 4698, 22827, 5418, 63125, 3476, 5802, 43701, 2484, 5302, 27223, 2646, 70954, 7466, 3412, 54698, 5482, 2412, 38062, 5294, 2636, 32038, 6954, 60245, 2772, 4826, 43357, 2394, 5274, 39501, 6730, 72357, 5800, 5844, 53978, 4790, 2358, 38039, 5270, 87627, 3402, 3496, 54708, 5484, 4782, 43311, 2350, 3222, 27978, 7498, 68965, 2904, 5484, 45677, 4700, 6444, 39573, 6804, 6986, 19285, 2772, 62811, 1210, 4698, 47403, 5418, 5780, 38570, 5546, 76469, 2420, 5302, 51799, 2646, 5414, 36501, 3412, 5546, 18869, 2412, 54446, 5276, 6732, 48422, 6822, 2900, 28010, 4826, 92509, 2394, 5274, 55883, 6730, 6820, 47956, 5812, 2778, 18779, 2358, 62615, 5270, 5450, 46757, 3492, 5556, 27318, 4718, 67887, 2350, 3222, 52554, 7498, 3428, 38252, 5468, 4700, 31022, 6444, 64149, 6804, 6986, 43861, 2772, 5338, 35421, 2650, 70955, 5418, 5780, 54954, 5546, 2740, 38074, 5302, 2646, 29991, 3366, 61011, 3412, 5546, 43445, 2412, 5294, 35406, 6732, 72998, 6820, 6996, 52586, 2778, 2396, 38045, 5274, 6698, 23333, 6820, 64338};
    private static final int[] DAYS_AND_LEAP_MONTH_OF_LUNAR = new int[]{1897, 971830, 972362, 972863, 973395, 973896, 974397, 974928, 975428, 975929, 976461, 976962, 977462, 977994, 978494, 979026, 979526, 980026, 980558, 981059, 981559, 982091, 982593, 983124, 983624, 984124, 984656, 985157, 985656, 986189, 986690, 987191, 987722, 988222, 988753, 989254, 989754, 990286, 990788, 991288, 991819, 992319, 992851, 993352, 993851, 994383, 994885, 995385, 995917, 996418, 996918, 997450, 997949, 998481, 998982, 999483, 1000014, 1000515, 1001016, 1001548, 1002047, 1002578, 1003080, 1003580, 1004111, 1004613, 1005113, 1005645, 1006146, 1006645, 1007177, 1007678, 1008209, 1008710, 1009211, 1009743, 1010243, 1010743, 1011275, 1011775, 1012306, 1012807, 1013308, 1013840, 1014341, 1014841, 1015373, 1015874, 1016404, 1016905, 1017405, 1017937, 1018438, 1018939, 1019471, 1019972, 1020471, 1021002, 1021503, 1022035, 1022535, 1023036, 1023568, 1024069, 1024568, 1025100, 1025601, 1026102, 1026633, 1027133, 1027666, 1028167, 1028666, 1029198, 1029699, 1030199, 1030730, 1031231, 1031763, 1032264, 1032764, 1033296, 1033797, 1034297, 1034828, 1035329, 1035830, 1036362, 1036861, 1037393, 1037894, 1038394, 1038925, 1039427, 1039927, 1040459, 1040959, 1041491, 1041992, 1042492, 1043023, 1043524, 1044024, 1044556, 1045057, 1045558, 1046090, 1046590, 1047121, 1047622, 1048122, 1048654, 1049154, 1049655, 1050187, 1050689, 1051219, 1051720, 1052220, 1052751, 1053252, 1053752, 1054284, 1054786, 1055285, 1055817, 1056317, 1056849, 1057349, 1057850, 1058382, 1058883, 1059383, 1059915, 1060415, 1060947, 1061447, 1061947, 1062479, 1062981, 1063480, 1064012, 1064514, 1065014, 1065545, 1066045, 1066577, 1067078, 1067578, 1068110, 1068611, 1069112, 1069642, 1070142, 1070674, 1071175, 1071675, 1072207, 1072709, 1073209, 1073740, 1074241, 1074741, 1075273, 1075773};
    private static final String[] NUMBER_CAPITAL = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] LUNAR_HEADER = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", "\u6b63", "\u814a", "\u51ac", "\u95f0"};
    private static final String[][] FESTIVAL_G = new String[][]{{"\u5143\u65e6"}, {"\u4e16\u754c\u6e7f\u5730\u65e5", "\u60c5\u4eba\u8282"}, {"\u5168\u56fd\u7231\u8033\u65e5", "\u9752\u5e74\u5fd7\u613f\u8005\u670d\u52a1\u65e5", "\u56fd\u9645\u5987\u5973\u8282", "\u4fdd\u62a4\u6bcd\u4eb2\u6cb3\u65e5", "\u4e2d\u56fd\u690d\u6811\u8282", "\u767d\u8272\u60c5\u4eba\u8282&\u56fd\u9645\u8b66\u5bdf\u65e5", "\u4e16\u754c\u6d88\u8d39\u8005\u6743\u76ca\u65e5", "\u4e16\u754c\u68ee\u6797\u65e5&\u4e16\u754c\u7761\u7720\u65e5", "\u4e16\u754c\u6c34\u65e5", "\u4e16\u754c\u6c14\u8c61\u65e5", "\u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5"}, {"\u611a\u4eba\u8282", "\u6e05\u660e\u8282", "\u4e16\u754c\u536b\u751f\u65e5", "\u4e16\u754c\u5730\u7403\u65e5", "\u4e16\u754c\u77e5\u8bc6\u4ea7\u6743\u65e5"}, {"\u56fd\u9645\u52b3\u52a8\u8282", "\u4e16\u754c\u54ee\u5598\u65e5", "\u4e2d\u56fd\u9752\u5e74\u8282", "\u4e16\u754c\u7ea2\u5341\u5b57\u65e5", "\u56fd\u9645\u62a4\u58eb\u8282", "\u56fd\u9645\u5bb6\u5ead\u65e5", "\u4e16\u754c\u7535\u4fe1\u65e5", "\u5168\u56fd\u5b66\u751f\u8425\u517b\u65e5", "\u56fd\u9645\u751f\u7269\u591a\u6837\u6027\u65e5", "\u56fd\u9645\u725b\u5976\u65e5", "\u4e16\u754c\u65e0\u70df\u65e5"}, {"\u56fd\u9645\u513f\u7ae5\u8282", "\u4e16\u754c\u73af\u5883\u65e5", "\u5168\u56fd\u7231\u773c\u65e5", "\u4e16\u754c\u9632\u6cbb\u8352\u6f20\u5316\u65e5", "\u56fd\u9645\u5965\u6797\u5339\u514b\u65e5", "\u5168\u56fd\u571f\u5730\u65e5", "\u56fd\u9645\u7981\u6bd2\u65e5"}, {"\u4e2d\u56fd\u5171\u4ea7\u515a\u8bde\u751f\u65e5&\u56fd\u9645\u5efa\u7b51\u65e5", "\u4e2d\u56fd\u6297\u6218\u7eaa\u5ff5\u65e5", "\u4e16\u754c\u4eba\u53e3\u65e5"}, {"\u4e2d\u56fd\u89e3\u653e\u519b\u5efa\u519b\u8282", "\u56fd\u9645\u9752\u5e74\u8282"}, {"\u6297\u6218\u80dc\u5229\u65e5", "\u56fd\u9645\u626b\u76f2\u65e5", "\u4e2d\u56fd\u6559\u5e08\u8282", "\u4e2d\u56fd\u8111\u5065\u5eb7\u65e5&\u81ed\u6c27\u5c42\u4fdd\u62a4\u65e5", "\u5168\u56fd\u7231\u7259\u65e5", "\u4e16\u754c\u505c\u706b\u65e5", "\u4e16\u754c\u65c5\u6e38\u65e5"}, {"\u56fd\u5e86\u8282&\u56fd\u9645\u8001\u5e74\u4eba\u65e5", "\u4e16\u754c\u52a8\u7269\u65e5", "\u4e16\u754c\u6559\u5e08\u65e5", "\u5168\u56fd\u9ad8\u8840\u538b\u65e5", "\u4e16\u754c\u90ae\u653f\u65e5", "\u4e16\u754c\u7cbe\u795e\u536b\u751f\u65e5", "\u4e16\u754c\u6807\u51c6\u65e5", "\u56fd\u9645\u76f2\u4eba\u8282&\u4e16\u754c\u519c\u6751\u5987\u5973\u65e5", "\u4e16\u754c\u7cae\u98df\u65e5", "\u56fd\u9645\u6d88\u9664\u8d2b\u56f0\u65e5", "\u8054\u5408\u56fd\u65e5&\u4e16\u754c\u53d1\u5c55\u65b0\u95fb\u65e5", "\u4e2d\u56fd\u7537\u6027\u5065\u5eb7\u65e5", "\u4e07\u5723\u8282"}, {"\u4e2d\u56fd\u8bb0\u8005\u8282", "\u6d88\u9632\u5ba3\u4f20\u65e5", "\u4e16\u754c\u7cd6\u5c3f\u75c5\u65e5", "\u56fd\u9645\u5927\u5b66\u751f\u8282", "\u6d88\u9664\u5bf9\u5987\u5973\u66b4\u529b\u65e5"}, {"\u4e16\u754c\u7231\u6ecb\u75c5\u65e5", "\u4e16\u754c\u6b8b\u75be\u4eba\u65e5", "\u5168\u56fd\u6cd5\u5236\u5ba3\u4f20\u65e5", "\u4e16\u754c\u8db3\u7403\u65e5", "\u5723\u8bde\u8282"}};
    private static final int[][] FESTIVAL_G_DATE = new int[][]{{1}, {2, 14}, {3, 5, 8, 9, 12, 14, 15, 21, 22, 23, 24}, {1, 5, 7, 22, 26}, {1, 3, 4, 8, 12, 15, 17, 20, 22, 23, 31}, {1, 5, 6, 17, 23, 25, 26}, {1, 7, 11}, {1, 12}, {3, 8, 10, 16, 20, 21, 27}, {1, 4, 5, 8, 9, 10, 14, 15, 16, 17, 24, 29, 31}, {8, 9, 14, 17, 25}, {1, 3, 4, 9, 25}};
    private static final String[][] FESTIVAL_L = new String[][]{{"\u6625\u8282", "\u5143\u5bb5\u8282"}, new String[0], new String[0], new String[0], {"\u7aef\u5348\u8282"}, new String[0], {"\u4e5e\u5de7\u8282"}, {"\u4e2d\u79cb\u8282"}, {"\u91cd\u9633\u8282"}, new String[0], new String[0], {"\u814a\u516b\u8282", "\u626b\u623f\u65e5"}};
    private static final int[][] FESTIVAL_L_DATE = new int[][]{{1, 15}, new int[0], new int[0], new int[0], {5}, new int[0], {7}, {15}, {9}, new int[0], new int[0], {8, 24}};
    private static final String[][] HOLIDAY = new String[][]{{"1", "2", "3"}, {"18", "19", "20", "21", "22", "23", "24"}, {""}, {"4", "5", "6"}, {"1", "2", "3"}, {"20", "21", "22"}, {""}, {""}, {"3", "4", "5", "26", "27"}, {"1", "2", "3", "4", "5", "6", "7"}, {""}, {""}};
    private static final String[][] DEFERRED = new String[][]{{"4"}, {"15", "16", "17", "25", "26", "27", "28"}, {""}, {""}, {""}, {""}, {""}, {""}, {"6", "28", "29", "30"}, {"8", "9", "10"}, {""}, {""}};
    private static final String[][] SOLAR_TERM = new String[][]{{"\u5c0f\u5bd2", "\u5927\u5bd2"}, {"\u7acb\u6625", "\u96e8\u6c34"}, {"\u60ca\u86f0", "\u6625\u5206"}, {"\u6e05\u660e", "\u8c37\u96e8"}, {"\u7acb\u590f", "\u5c0f\u6ee1"}, {"\u8292\u79cd", "\u590f\u81f3"}, {"\u5c0f\u6691", "\u5927\u6691"}, {"\u7acb\u79cb", "\u5904\u6691"}, {"\u767d\u9732", "\u79cb\u5206"}, {"\u5bd2\u9732", "\u971c\u964d"}, {"\u7acb\u51ac", "\u5c0f\u96ea"}, {"\u5927\u96ea", "\u51ac\u81f3"}};
    private final HashMap<Integer, String[][]> CACHE_SOLAR_TERM = new HashMap();
    private SolarTerm mSolarTerm = new SolarTerm();

    @Override
    public String[][] buildMonthFestival(int year, int month) {
        return this.buildMonthL(year, month);
    }

    @Override
    public Set<String> buildMonthHoliday(int year, int month) {
        HashSet<String> tmp = new HashSet<String>();
        if (year == 2015) {
            Collections.addAll(tmp, HOLIDAY[month - 1]);
        }
        return tmp;
    }

    private String[][] buildMonthL(int year, int month) {
        String[][] gregorianMonth = this.buildMonthG(year, month);
        G g = new G();
        String[][] tmp = new String[6][7];
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[0].length; ++j) {
                tmp[i][j] = "";
                if (TextUtils.isEmpty((CharSequence)gregorianMonth[i][j])) continue;
                g.y = year;
                g.m = month;
                g.d = Integer.valueOf(gregorianMonth[i][j]);
                L l = null;
                String result = "";
                if (year >= 1900 && year <= 2100) {
                    l = this.GTL(g);
                    result = this.getFestivalL(l.m, l.d);
                }
                if (TextUtils.isEmpty((CharSequence)result)) {
                    result = this.getFestivalG(g.m, g.d);
                    if (TextUtils.isEmpty((CharSequence)result)) {
                        result = this.getSolarTerm(year, month, g.d);
                        if (null != l && TextUtils.isEmpty((CharSequence)result)) {
                            char[] c = String.valueOf(l.d).toCharArray();
                            tmp[i][j] = this.lNumToStr(c);
                            continue;
                        }
                        tmp[i][j] = result;
                        continue;
                    }
                    tmp[i][j] = result + "F";
                    continue;
                }
                tmp[i][j] = result + "F";
            }
        }
        return tmp;
    }

    public boolean isSolarTerm(int year, int month, int day) {
        return null == this.getSolarTerm(year, month, day);
    }

    public boolean isDeferred(int year, int month, int day) {
        if (year == 2015) {
            String[] deferredOfMonth;
            for (String s : deferredOfMonth = DEFERRED[month - 1]) {
                if (TextUtils.isEmpty((CharSequence)s) || Integer.valueOf(s) != day) continue;
                return true;
            }
        }
        return false;
    }

    private String getSolarTerm(int year, int month, int day) {
        String[] STOfMonth;
        String[][] tmp = this.CACHE_SOLAR_TERM.get(year);
        if (null == tmp) {
            tmp = this.mSolarTerm.buildSolarTerm(year);
            this.CACHE_SOLAR_TERM.put(year, tmp);
        }
        if (Integer.valueOf((STOfMonth = tmp[month - 1])[0]) == day) {
            return SOLAR_TERM[month - 1][0];
        }
        if (Integer.valueOf(STOfMonth[1]) == day) {
            return SOLAR_TERM[month - 1][1];
        }
        return "";
    }

    private String getFestivalL(int month, int day) {
        String tmp = "";
        int[] daysInMonth = FESTIVAL_L_DATE[month - 1];
        for (int i = 0; i < daysInMonth.length; ++i) {
            if (day != daysInMonth[i]) continue;
            tmp = FESTIVAL_L[month - 1][i];
        }
        return tmp;
    }

    private String getFestivalG(int month, int day) {
        String tmp = "";
        int[] daysInMonth = FESTIVAL_G_DATE[month - 1];
        for (int i = 0; i < daysInMonth.length; ++i) {
            if (day != daysInMonth[i]) continue;
            tmp = FESTIVAL_G[month - 1][i];
        }
        return tmp;
    }

    private L GTL(G g) {
        int index = g.y - DAYS_AND_LEAP_MONTH_OF_LUNAR[0];
        int data = g.y << 9 | g.m << 5 | g.d;
        if (DAYS_AND_LEAP_MONTH_OF_LUNAR[index] > data) {
            --index;
        }
        int lunarFirstDayInGregorian = DAYS_AND_LEAP_MONTH_OF_LUNAR[index];
        int y = this.getBitInt(lunarFirstDayInGregorian, 12, 9);
        int m = this.getBitInt(lunarFirstDayInGregorian, 4, 5);
        int d = this.getBitInt(lunarFirstDayInGregorian, 5, 0);
        long offset = this.GToNum(g.y, g.m, g.d) - this.GToNum(y, m, d);
        int days = FIRST_DAY_OF_LUNAR_IN_GREGORIAN[index];
        int leap = this.getBitInt(days, 4, 13);
        int lunarY = index + DAYS_AND_LEAP_MONTH_OF_LUNAR[0];
        int lunarM = 1;
        ++offset;
        for (int i = 0; i < 13; ++i) {
            int dm;
            int n = dm = this.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
            if (offset <= (long)dm) break;
            ++lunarM;
            offset -= (long)dm;
        }
        int lunarD = (int)offset;
        L l = new L();
        l.y = lunarY;
        l.m = lunarM;
        l.isLeap = false;
        if (leap != 0 && lunarM > leap) {
            l.m = lunarM - 1;
            if (lunarM == leap + 1) {
                l.isLeap = true;
            }
        }
        l.d = lunarD;
        return l;
    }

    private String lNumToStr(char[] c) {
        String result = "";
        if (c.length == 1) {
            for (int i = 1; i < 10; ++i) {
                if (c[0] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[0] + NUMBER_CAPITAL[i];
            }
        } else if (c[0] == '1') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[0] + LUNAR_HEADER[1];
            } else {
                for (int i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[1] + NUMBER_CAPITAL[i];
                }
            }
        } else if (c[0] == '2') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[2] + LUNAR_HEADER[1];
            } else {
                for (int i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[2] + NUMBER_CAPITAL[i];
                }
            }
        } else if (c[1] == '0') {
            result = LUNAR_HEADER[3] + LUNAR_HEADER[1];
        } else {
            for (int i = 1; i < 10; ++i) {
                if (c[1] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[3] + NUMBER_CAPITAL[i];
            }
        }
        return result;
    }

    private class L {
        int d;
        int m;
        int y;
        boolean isLeap;

        private L() {
        }
    }

    private class G {
        int d;
        int m;
        int y;

        private G() {
        }
    }
}

