/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.tasks.api.ISchemaInitializationProvider;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeSchemaTask
extends BaseTask {
    public static final String DESCRIPTION_PREFIX = "Initialize schema for ";
    private static final Logger ourLog = LoggerFactory.getLogger(InitializeSchemaTask.class);
    private final ISchemaInitializationProvider mySchemaInitializationProvider;
    private boolean myInitializedSchema;

    public InitializeSchemaTask(String theProductVersion, String theSchemaVersion, ISchemaInitializationProvider theSchemaInitializationProvider) {
        super(theProductVersion, theSchemaVersion);
        this.mySchemaInitializationProvider = theSchemaInitializationProvider;
        this.setDescription(DESCRIPTION_PREFIX + this.mySchemaInitializationProvider.getSchemaDescription());
    }

    @Override
    public boolean isRunDuringSchemaInitialization() {
        return true;
    }

    @Override
    public void validate() {
    }

    @Override
    public void doExecute() throws SQLException {
        String schemaExistsIndicatorTable;
        DriverTypeEnum driverType = this.getDriverType();
        Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
        if (tableNames.contains(schemaExistsIndicatorTable = this.mySchemaInitializationProvider.getSchemaExistsIndicatorTable())) {
            this.logInfo(ourLog, "The table {} already exists.  Skipping schema initialization for {}", new Object[]{schemaExistsIndicatorTable, driverType});
            return;
        }
        this.logInfo(ourLog, "Initializing {} schema for {}", new Object[]{driverType, this.mySchemaInitializationProvider.getSchemaDescription()});
        List<String> sqlStatements = this.mySchemaInitializationProvider.getSqlStatements(driverType);
        for (String nextSql : sqlStatements) {
            this.executeSql(null, nextSql, new Object[0]);
        }
        if (this.mySchemaInitializationProvider.canInitializeSchema()) {
            this.myInitializedSchema = true;
        }
        this.logInfo(ourLog, "{} schema for {} initialized successfully", new Object[]{driverType, this.mySchemaInitializationProvider.getSchemaDescription()});
    }

    @Override
    public boolean initializedSchema() {
        return this.myInitializedSchema;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        InitializeSchemaTask otherObject = (InitializeSchemaTask)theOtherObject;
        theBuilder.append((Object)this.mySchemaInitializationProvider, (Object)otherObject.mySchemaInitializationProvider);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append((Object)this.mySchemaInitializationProvider);
    }

    public ISchemaInitializationProvider getSchemaInitializationProvider() {
        return this.mySchemaInitializationProvider;
    }
}

