/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseColumnCalculatorTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class BaseTableColumnTask
extends BaseTableTask {
    protected Map<String, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object>> myCalculators = new HashMap<String, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object>>();
    protected String myColumnName;
    protected String myWhereClause;

    public BaseTableColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public String getColumnName() {
        return this.myColumnName;
    }

    public BaseTableColumnTask setColumnName(String theColumnName) {
        this.myColumnName = theColumnName.toUpperCase();
        return this;
    }

    protected String getWhereClause() {
        if (this.myWhereClause == null) {
            return this.getColumnName() + " IS NULL";
        }
        return this.myWhereClause;
    }

    protected void setWhereClause(String theWhereClause) {
        this.myWhereClause = theWhereClause;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myColumnName, (String)"Column name not specified", (Object[])new Object[0]);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        BaseTableColumnTask otherObject = (BaseTableColumnTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myColumnName, (Object)otherObject.myColumnName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myColumnName);
    }

    public BaseTableColumnTask addCalculator(String theColumnName, Function<BaseColumnCalculatorTask.MandatoryKeyMap<String, Object>, Object> theConsumer) {
        Validate.isTrue((!this.myCalculators.containsKey(theColumnName) ? 1 : 0) != 0);
        this.myCalculators.put(theColumnName, theConsumer);
        return this;
    }
}

