/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class AddTableRawSqlTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddTableRawSqlTask.class);
    private Map<DriverTypeEnum, List<String>> myDriverToSqls = new HashMap<DriverTypeEnum, List<String>>();
    private List<String> myDriverNeutralSqls = new ArrayList<String>();

    public AddTableRawSqlTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Add table using raw sql");
    }

    public void addSql(DriverTypeEnum theDriverType, @Language(value="SQL") String theSql) {
        Validate.notNull((Object)((Object)theDriverType));
        Validate.notBlank((CharSequence)theSql);
        List list = this.myDriverToSqls.computeIfAbsent(theDriverType, t -> new ArrayList());
        list.add(theSql);
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
        if (tableNames.contains(this.getTableName())) {
            this.logInfo(ourLog, "Table {} already exists - No action performed", this.getTableName());
            return;
        }
        List sqlStatements = this.myDriverToSqls.computeIfAbsent(this.getDriverType(), t -> new ArrayList());
        sqlStatements.addAll(this.myDriverNeutralSqls);
        this.logInfo(ourLog, "Going to create table {} using {} SQL statements", this.getTableName(), sqlStatements.size());
        this.getConnectionProperties().getTxTemplate().execute(t -> {
            JdbcTemplate jdbcTemplate = this.getConnectionProperties().newJdbcTemplate();
            for (String nextSql : sqlStatements) {
                jdbcTemplate.execute(nextSql);
            }
            return null;
        });
    }

    public void addSql(String theSql) {
        Validate.notBlank((CharSequence)"theSql must not be null", (String)theSql, (Object[])new Object[0]);
        this.myDriverNeutralSqls.add(theSql);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        super.generateEquals(theBuilder, theOtherObject);
        AddTableRawSqlTask otherObject = (AddTableRawSqlTask)theOtherObject;
        theBuilder.append(this.myDriverNeutralSqls, otherObject.myDriverNeutralSqls);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append(this.myDriverNeutralSqls);
    }
}

