/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.NormalizingIdentifierHelperImpl;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.LobCreatorBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.TypeInfo;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(JdbcUtils.class);

    public static Set<String> getIndexNames(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName) throws SQLException {
        if (!JdbcUtils.getTableNames(theConnectionProperties).contains(theTableName)) {
            return Collections.emptySet();
        }
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            Set set = (Set)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    String indexName;
                    DatabaseMetaData metadata = connection.getMetaData();
                    ResultSet indexes = JdbcUtils.getIndexInfo(theTableName, connection, metadata, false);
                    Set<Object> indexNames = new HashSet<String>();
                    while (indexes.next()) {
                        ourLog.debug("*** Next index: {}", (Object)new ColumnMapRowMapper().mapRow(indexes, 0));
                        indexName = indexes.getString("INDEX_NAME");
                        indexNames.add(indexName);
                    }
                    indexes = JdbcUtils.getIndexInfo(theTableName, connection, metadata, true);
                    while (indexes.next()) {
                        ourLog.debug("*** Next index: {}", (Object)new ColumnMapRowMapper().mapRow(indexes, 0));
                        indexName = indexes.getString("INDEX_NAME");
                        indexNames.add(indexName);
                    }
                    indexNames = indexNames.stream().filter(Objects::nonNull).map(s -> s.toUpperCase(Locale.US)).collect(Collectors.toSet());
                    return indexNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)29) + e);
                }
            });
            return set;
        }
    }

    public static boolean isIndexUnique(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, String theIndexName) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            boolean bl = (Boolean)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    ResultSet indexes = JdbcUtils.getIndexInfo(theTableName, connection, metadata, false);
                    while (indexes.next()) {
                        String indexName = indexes.getString("INDEX_NAME");
                        if (!theIndexName.equalsIgnoreCase(indexName)) continue;
                        boolean nonUnique = indexes.getBoolean("NON_UNIQUE");
                        return !nonUnique;
                    }
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)30) + e);
                }
                throw new InternalErrorException(Msg.code((int)31) + "Can't find index: " + theIndexName + " on table " + theTableName);
            });
            return bl;
        }
    }

    private static ResultSet getIndexInfo(String theTableName, Connection theConnection, DatabaseMetaData theMetadata, boolean theUnique) throws SQLException {
        boolean approximate = true;
        return theMetadata.getIndexInfo(theConnection.getCatalog(), theConnection.getSchema(), JdbcUtils.massageIdentifier(theMetadata, theTableName), theUnique, approximate);
    }

    public static ColumnType getColumnType(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, String theColumnName) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            ColumnType columnType = (ColumnType)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    String catalog = connection.getCatalog();
                    String schema = connection.getSchema();
                    ResultSet indexes = metadata.getColumns(catalog, schema, JdbcUtils.massageIdentifier(metadata, theTableName), null);
                    while (indexes.next()) {
                        String columnName;
                        String tableName = indexes.getString("TABLE_NAME").toUpperCase(Locale.US);
                        if (!theTableName.equalsIgnoreCase(tableName) || !theColumnName.equalsIgnoreCase(columnName = indexes.getString("COLUMN_NAME").toUpperCase(Locale.US))) continue;
                        int dataType = indexes.getInt("DATA_TYPE");
                        Long length = indexes.getLong("COLUMN_SIZE");
                        switch (dataType) {
                            case -7: 
                            case 16: {
                                return new ColumnType(ColumnTypeEnum.BOOLEAN, length);
                            }
                            case 12: {
                                return new ColumnType(ColumnTypeEnum.STRING, length);
                            }
                            case -5: 
                            case 2: 
                            case 3: {
                                return new ColumnType(ColumnTypeEnum.LONG, length);
                            }
                            case 4: {
                                return new ColumnType(ColumnTypeEnum.INT, length);
                            }
                            case 93: 
                            case 2014: {
                                return new ColumnType(ColumnTypeEnum.DATE_TIMESTAMP, length);
                            }
                            case 2004: {
                                return new ColumnType(ColumnTypeEnum.BLOB, length);
                            }
                            case -4: {
                                if (DriverTypeEnum.MYSQL_5_7.equals((Object)theConnectionProperties.getDriverType())) {
                                    return new ColumnType(ColumnTypeEnum.BLOB, length);
                                }
                                throw new IllegalArgumentException(Msg.code((int)32) + "Don't know how to handle datatype " + dataType + " for column " + theColumnName + " on table " + theTableName);
                            }
                            case -3: {
                                if (DriverTypeEnum.MSSQL_2012.equals((Object)theConnectionProperties.getDriverType())) {
                                    return new ColumnType(ColumnTypeEnum.BLOB, length);
                                }
                                throw new IllegalArgumentException(Msg.code((int)33) + "Don't know how to handle datatype " + dataType + " for column " + theColumnName + " on table " + theTableName);
                            }
                            case 2005: {
                                return new ColumnType(ColumnTypeEnum.CLOB, length);
                            }
                            case 8: {
                                return new ColumnType(ColumnTypeEnum.DOUBLE, length);
                            }
                            case 6: {
                                return new ColumnType(ColumnTypeEnum.FLOAT, length);
                            }
                        }
                        throw new IllegalArgumentException(Msg.code((int)34) + "Don't know how to handle datatype " + dataType + " for column " + theColumnName + " on table " + theTableName);
                    }
                    ourLog.debug("Unable to find column {} in table {}.", (Object)theColumnName, (Object)theTableName);
                    return null;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)35) + e);
                }
            });
            return columnType;
        }
    }

    public static Set<String> getForeignKeys(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, @Nullable String theForeignTable) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            TransactionTemplate txTemplate = theConnectionProperties.getTxTemplate();
            Set set = (Set)txTemplate.execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    String catalog = connection.getCatalog();
                    String schema = connection.getSchema();
                    ArrayList<String> parentTables = new ArrayList<String>();
                    if (theTableName != null) {
                        parentTables.add(JdbcUtils.massageIdentifier(metadata, theTableName));
                    } else {
                        parentTables.addAll(JdbcUtils.getTableNames(theConnectionProperties));
                    }
                    String foreignTable = JdbcUtils.massageIdentifier(metadata, theForeignTable);
                    HashSet<String> fkNames = new HashSet<String>();
                    for (String nextParentTable : parentTables) {
                        ResultSet indexes = metadata.getCrossReference(catalog, schema, nextParentTable, catalog, schema, foreignTable);
                        while (indexes.next()) {
                            String fkName = indexes.getString("FK_NAME");
                            fkName = fkName.toUpperCase(Locale.US);
                            fkNames.add(fkName);
                        }
                    }
                    return fkNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)36) + e);
                }
            });
            return set;
        }
    }

    public static Set<String> getForeignKeysForColumn(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theForeignKeyColumn, String theForeignTable) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            Set set = (Set)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    String catalog = connection.getCatalog();
                    String schema = connection.getSchema();
                    ArrayList<String> parentTables = new ArrayList<String>();
                    parentTables.addAll(JdbcUtils.getTableNames(theConnectionProperties));
                    String foreignTable = JdbcUtils.massageIdentifier(metadata, theForeignTable);
                    HashSet<String> fkNames = new HashSet<String>();
                    for (String nextParentTable : parentTables) {
                        ResultSet indexes = metadata.getCrossReference(catalog, schema, nextParentTable, catalog, schema, foreignTable);
                        while (indexes.next()) {
                            if (!theForeignKeyColumn.equals(indexes.getString("FKCOLUMN_NAME"))) continue;
                            String fkName = indexes.getString("FK_NAME");
                            fkName = fkName.toUpperCase(Locale.US);
                            fkNames.add(fkName);
                        }
                    }
                    return fkNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)37) + e);
                }
            });
            return set;
        }
    }

    public static Set<String> getColumnNames(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            Set set = (Set)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    ResultSet indexes = metadata.getColumns(connection.getCatalog(), connection.getSchema(), JdbcUtils.massageIdentifier(metadata, theTableName), null);
                    HashSet<String> columnNames = new HashSet<String>();
                    while (indexes.next()) {
                        String tableName = indexes.getString("TABLE_NAME").toUpperCase(Locale.US);
                        if (!theTableName.equalsIgnoreCase(tableName)) continue;
                        String columnName = indexes.getString("COLUMN_NAME");
                        columnName = columnName.toUpperCase(Locale.US);
                        columnNames.add(columnName);
                    }
                    return columnNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)38) + e);
                }
            });
            return set;
        }
    }

    public static Set<String> getSequenceNames(DriverTypeEnum.ConnectionProperties theConnectionProperties) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (final Connection connection = dataSource.getConnection();){
            Set set = (Set)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    StandardDialectResolver dialectResolver = new StandardDialectResolver();
                    final Dialect dialect = dialectResolver.resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
                    HashSet<String> sequenceNames = new HashSet<String>();
                    if (dialect.supportsSequences()) {
                        SequenceInformationExtractor sequenceInformationExtractor = dialect.getSequenceInformationExtractor();
                        ExtractionContext.EmptyExtractionContext extractionContext = new ExtractionContext.EmptyExtractionContext(){

                            public Connection getJdbcConnection() {
                                return connection;
                            }

                            public ServiceRegistry getServiceRegistry() {
                                return super.getServiceRegistry();
                            }

                            public JdbcEnvironment getJdbcEnvironment() {
                                return new JdbcEnvironment(){

                                    public Dialect getDialect() {
                                        return dialect;
                                    }

                                    public ExtractedDatabaseMetaData getExtractedDatabaseMetaData() {
                                        return null;
                                    }

                                    public Identifier getCurrentCatalog() {
                                        return null;
                                    }

                                    public Identifier getCurrentSchema() {
                                        return null;
                                    }

                                    public QualifiedObjectNameFormatter getQualifiedObjectNameFormatter() {
                                        return null;
                                    }

                                    public IdentifierHelper getIdentifierHelper() {
                                        return new NormalizingIdentifierHelperImpl((JdbcEnvironment)this, null, true, true, true, null, null, null);
                                    }

                                    public NameQualifierSupport getNameQualifierSupport() {
                                        return null;
                                    }

                                    public SqlExceptionHelper getSqlExceptionHelper() {
                                        return null;
                                    }

                                    public LobCreatorBuilder getLobCreatorBuilder() {
                                        return null;
                                    }

                                    public TypeInfo getTypeInfoForJdbcCode(int jdbcTypeCode) {
                                        return null;
                                    }
                                };
                            }
                        };
                        Iterable sequences = sequenceInformationExtractor.extractMetadata((ExtractionContext)extractionContext);
                        for (SequenceInformation next : sequences) {
                            sequenceNames.add(next.getSequenceName().getSequenceName().getText());
                        }
                    }
                    return sequenceNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)39) + e);
                }
            });
            return set;
        }
    }

    public static Set<String> getTableNames(DriverTypeEnum.ConnectionProperties theConnectionProperties) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            Set set = (Set)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    ResultSet tables = metadata.getTables(connection.getCatalog(), connection.getSchema(), null, null);
                    HashSet<String> columnNames = new HashSet<String>();
                    while (tables.next()) {
                        String tableName = tables.getString("TABLE_NAME");
                        tableName = tableName.toUpperCase(Locale.US);
                        String tableType = tables.getString("TABLE_TYPE");
                        if ("SYSTEM TABLE".equalsIgnoreCase(tableType) || "FLY_HFJ_MIGRATION".equalsIgnoreCase(tableName)) continue;
                        columnNames.add(tableName);
                    }
                    return columnNames;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)40) + e);
                }
            });
            return set;
        }
    }

    public static boolean isColumnNullable(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, String theColumnName) throws SQLException {
        DataSource dataSource = Objects.requireNonNull(theConnectionProperties.getDataSource());
        try (Connection connection = dataSource.getConnection();){
            boolean bl = (Boolean)theConnectionProperties.getTxTemplate().execute(t -> {
                try {
                    DatabaseMetaData metadata = connection.getMetaData();
                    ResultSet tables = metadata.getColumns(connection.getCatalog(), connection.getSchema(), JdbcUtils.massageIdentifier(metadata, theTableName), null);
                    while (tables.next()) {
                        String tableName = tables.getString("TABLE_NAME").toUpperCase(Locale.US);
                        if (!theTableName.equalsIgnoreCase(tableName) || !theColumnName.equalsIgnoreCase(tables.getString("COLUMN_NAME"))) continue;
                        String nullable = tables.getString("IS_NULLABLE");
                        if ("YES".equalsIgnoreCase(nullable)) {
                            return true;
                        }
                        if ("NO".equalsIgnoreCase(nullable)) {
                            return false;
                        }
                        throw new IllegalStateException(Msg.code((int)41) + "Unknown nullable: " + nullable);
                    }
                    throw new IllegalStateException(Msg.code((int)42) + "Did not find column " + theColumnName);
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)43) + e);
                }
            });
            return bl;
        }
    }

    private static String massageIdentifier(DatabaseMetaData theMetadata, String theCatalog) throws SQLException {
        String retVal = theCatalog;
        if (theCatalog == null) {
            return null;
        }
        retVal = theMetadata.storesLowerCaseIdentifiers() ? retVal.toLowerCase() : retVal.toUpperCase();
        return retVal;
    }

    public static class ColumnType {
        private final ColumnTypeEnum myColumnTypeEnum;
        private final Long myLength;

        public ColumnType(ColumnTypeEnum theColumnType, Long theLength) {
            this.myColumnTypeEnum = theColumnType;
            this.myLength = theLength;
        }

        public ColumnType(ColumnTypeEnum theColumnType, int theLength) {
            this(theColumnType, Long.valueOf(theLength));
        }

        public ColumnType(ColumnTypeEnum theColumnType) {
            this(theColumnType, null);
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ColumnType that = (ColumnType)theO;
            return new EqualsBuilder().append((Object)this.myColumnTypeEnum, (Object)that.myColumnTypeEnum).append((Object)this.myLength, (Object)that.myLength).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.myColumnTypeEnum).append((Object)this.myLength).toHashCode();
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.append("type", (Object)this.myColumnTypeEnum);
            if (this.myLength != null) {
                b.append("length", (Object)this.myLength);
            }
            return b.toString();
        }

        public ColumnTypeEnum getColumnTypeEnum() {
            return this.myColumnTypeEnum;
        }

        public Long getLength() {
            return this.myLength;
        }

        public boolean equals(ColumnTypeEnum theTaskColumnType, Long theTaskColumnLength) {
            ourLog.debug("Comparing existing {} {} to new {} {}", new Object[]{this.myColumnTypeEnum, this.myLength, theTaskColumnType, theTaskColumnLength});
            return this.myColumnTypeEnum == theTaskColumnType && (theTaskColumnLength == null || theTaskColumnLength.equals(this.myLength));
        }
    }
}

