/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.IMigrator;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.flywaydb.core.api.callback.Callback;

public abstract class BaseMigrator
implements IMigrator {
    private final List<BaseTask.ExecutedStatement> myExecutedStatements = new ArrayList<BaseTask.ExecutedStatement>();
    private boolean myDryRun;
    private boolean myNoColumnShrink;
    private boolean mySchemaWasInitialized;
    private DriverTypeEnum myDriverType;
    private DataSource myDataSource;
    private boolean myStrictOrder;
    private List<Callback> myCallbacks = Collections.emptyList();

    @Nonnull
    public List<Callback> getCallbacks() {
        return this.myCallbacks;
    }

    public void setCallbacks(@Nonnull List<Callback> theCallbacks) {
        Validate.notNull(theCallbacks);
        this.myCallbacks = theCallbacks;
    }

    public DataSource getDataSource() {
        return this.myDataSource;
    }

    public void setDataSource(DataSource theDataSource) {
        this.myDataSource = theDataSource;
    }

    public boolean isDryRun() {
        return this.myDryRun;
    }

    public void setDryRun(boolean theDryRun) {
        this.myDryRun = theDryRun;
    }

    public boolean isNoColumnShrink() {
        return this.myNoColumnShrink;
    }

    public void setNoColumnShrink(boolean theNoColumnShrink) {
        this.myNoColumnShrink = theNoColumnShrink;
    }

    public DriverTypeEnum getDriverType() {
        return this.myDriverType;
    }

    public void setDriverType(DriverTypeEnum theDriverType) {
        this.myDriverType = theDriverType;
    }

    public boolean isStrictOrder() {
        return this.myStrictOrder;
    }

    public void setStrictOrder(boolean theStrictOrder) {
        this.myStrictOrder = theStrictOrder;
    }

    public void addExecutedStatements(List theExecutedStatements) {
        this.myExecutedStatements.addAll(theExecutedStatements);
    }

    protected StringBuilder buildExecutedStatementsString() {
        StringBuilder statementBuilder = new StringBuilder();
        String lastTable = null;
        for (BaseTask.ExecutedStatement next : this.myExecutedStatements) {
            if (!Objects.equals(lastTable, next.getTableName())) {
                statementBuilder.append("\n\n-- Table: ").append(next.getTableName()).append("\n");
                lastTable = next.getTableName();
            }
            statementBuilder.append(next.getSql()).append(";\n");
            for (Object nextArg : next.getArguments()) {
                statementBuilder.append("  -- Arg: ").append(nextArg).append("\n");
            }
        }
        return statementBuilder;
    }

    public boolean isSchemaWasInitialized() {
        return this.mySchemaWasInitialized;
    }

    public BaseMigrator setSchemaWasInitialized(boolean theSchemaWasInitialized) {
        this.mySchemaWasInitialized = theSchemaWasInitialized;
        return this;
    }
}

