/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.adsanalytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.app.AppCompatActivity;
import br.com.tattobr.android.adsanalytics.BaseApplication;
import br.com.tattobr.android.adsanalytics.R;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.LoadAdError;

public abstract class BaseActivity
extends AppCompatActivity {
    private final String SI_SHOW_INTERSTITIAL_AD = "br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD";
    private final String LAST_INTERSTITIAL_AD_MILIS = "br.com.tattobr.android.adsanalytics.LAST_INTERSTITIAL_AD_MILIS";
    private ViewGroup adContainerView;
    private AdView mAdView;
    private boolean mShowInterstitialAd;
    private boolean mSetupAdsCalled;
    private SharedPreferences mSharedPreferences;

    public abstract String getIntersticialAdUnitId();

    public abstract String getBannerAdUnitId();

    protected abstract long getInterstitialAdMilisInterval();

    public boolean showInterstitialAd(boolean persistOnResume) {
        BaseApplication application = (BaseApplication)this.getApplication();
        boolean isShowing = false;
        if (application != null) {
            InterstitialAd interstitialAd = application.getInterstitialAd();
            if (this.isInterstitialAdAllowedByTime() && interstitialAd != null && interstitialAd.isLoaded()) {
                this.mShowInterstitialAd = false;
                this.mSharedPreferences.edit().putLong("br.com.tattobr.android.adsanalytics.LAST_INTERSTITIAL_AD_MILIS", System.currentTimeMillis()).apply();
                interstitialAd.show();
                isShowing = true;
            } else {
                this.mShowInterstitialAd = persistOnResume;
            }
        }
        return isShowing;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.mShowInterstitialAd = savedInstanceState != null && savedInstanceState.getBoolean("br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD");
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD", this.mShowInterstitialAd);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
    }

    protected void onPause() {
        if (this.mAdView != null) {
            this.mAdView.pause();
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (!this.mSetupAdsCalled) {
            throw new IllegalStateException("must call setupAds on onCreate.");
        }
        if (this.mAdView != null) {
            this.mAdView.resume();
        }
        if (this.mShowInterstitialAd) {
            this.showInterstitialAd(true);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    protected final void setupAds() {
        if (!this.mSetupAdsCalled) {
            BaseApplication application;
            String adUnitId;
            this.mSetupAdsCalled = true;
            this.adContainerView = (ViewGroup)this.findViewById(R.id.ad_view_container);
            if (this.adContainerView != null) {
                this.adContainerView.post(new Runnable(){

                    @Override
                    public void run() {
                        BaseActivity.this.loadBanner();
                    }
                });
            }
            if ((adUnitId = this.getIntersticialAdUnitId()) != null && (application = (BaseApplication)this.getApplication()) != null) {
                application.setupInterstitialAd(adUnitId);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void loadBanner() {
        String adUnitId = this.getBannerAdUnitId();
        if (adUnitId != null && !adUnitId.isEmpty()) {
            this.mAdView = new AdView((Context)this);
            this.mAdView.setAdUnitId(adUnitId);
            this.adContainerView.removeAllViews();
            this.adContainerView.addView((View)this.mAdView);
            AdSize adSize = this.getAdSize();
            this.mAdView.setAdSize(adSize);
            AdRequest adRequest = this.createDefaultAdRequest();
            this.mAdView.setAdListener(new AdListener(){

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    BaseActivity.this.mAdView.setVisibility(8);
                    BaseActivity.this.adContainerView.setVisibility(8);
                }
            });
            this.mAdView.loadAd(adRequest);
        } else {
            this.adContainerView.setVisibility(8);
        }
    }

    private AdSize getAdSize() {
        Display display = this.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float density = outMetrics.density;
        float adWidthPixels = this.adContainerView.getWidth();
        if (adWidthPixels == 0.0f) {
            adWidthPixels = outMetrics.widthPixels;
        }
        int adWidth = (int)(adWidthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)this, (int)adWidth);
    }

    private AdRequest createDefaultAdRequest() {
        BaseApplication application = (BaseApplication)this.getApplication();
        return application != null ? application.createDefaultAdRequest() : new AdRequest.Builder().build();
    }

    private boolean isInterstitialAdAllowedByTime() {
        long currentTimeMillis = System.currentTimeMillis();
        long lastInterstitialAdDate = this.mSharedPreferences.getLong("br.com.tattobr.android.adsanalytics.LAST_INTERSTITIAL_AD_MILIS", 0L);
        return lastInterstitialAdDate == 0L || lastInterstitialAdDate > currentTimeMillis || currentTimeMillis - lastInterstitialAdDate > this.getInterstitialAdMilisInterval();
    }
}

