/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.adsanalytics;

import android.app.Application;
import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.firebase.analytics.FirebaseAnalytics;

public abstract class BaseApplication
extends Application {
    public static FirebaseAnalytics analytics;
    private InterstitialAd mInterstitialAd;
    private String mLastAdUnitId;

    public abstract AdRequest createDefaultAdRequest();

    public abstract String getApplicationCode();

    public void onCreate() {
        super.onCreate();
        analytics = FirebaseAnalytics.getInstance((Context)this);
        String applicationCode = this.getApplicationCode();
        if (applicationCode != null && !applicationCode.isEmpty()) {
            MobileAds.initialize((Context)this.getApplicationContext(), (String)applicationCode);
        }
    }

    public void setupInterstitialAd(String adUnitId) {
        if (adUnitId != null && !adUnitId.equals(this.mLastAdUnitId)) {
            this.mLastAdUnitId = adUnitId;
            this.mInterstitialAd = new InterstitialAd((Context)this);
            this.mInterstitialAd.setAdUnitId(adUnitId);
            this.mInterstitialAd.setAdListener(new AdListener(){

                public void onAdClosed() {
                    BaseApplication.this.requestNewInterstitial();
                }
            });
            this.requestNewInterstitial();
        }
    }

    private void requestNewInterstitial() {
        AdRequest adRequest = this.createDefaultAdRequest();
        this.mInterstitialAd.loadAd(adRequest);
    }

    public InterstitialAd getInterstitialAd() {
        return this.mInterstitialAd;
    }
}

