/*
 * Decompiled with CFR 0.152.
 */
package br.com.arch.toolkit.statemachine;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;

public abstract class StateMachine<STATE extends State> {
    private int currentStateKey = -1;
    private final SparseArray<STATE> stateMap = new SparseArray();
    private final Config config = new Config();
    private boolean started = false;

    protected abstract void performChangeState(@NonNull STATE var1);

    @NonNull
    public abstract STATE newStateInstance();

    public final Config getConfig() {
        return this.config;
    }

    public final int getCurrentStateKey() {
        return this.currentStateKey == -1 ? this.config.initialState : this.currentStateKey;
    }

    public final void start() {
        if (this.started) {
            throw new IllegalStateException("Machine already started");
        }
        if (this.getCurrentStateKey() <= -1) {
            return;
        }
        State state = (State)this.stateMap.get(this.getCurrentStateKey());
        if (state == null) {
            throw new IllegalStateException("State not found! Make sure to add all states before init the Machine");
        }
        this.started = true;
        this.changeState(this.getCurrentStateKey(), true);
    }

    public final void changeState(int stateKey, boolean forceChange, @Nullable OnChangeStateCallback onChangeState) {
        if (!this.started) {
            throw new IllegalStateException("Call StateMachine#start() method before make any state changes");
        }
        if (stateKey == this.getCurrentStateKey() && !forceChange) {
            return;
        }
        State state = (State)this.stateMap.get(stateKey);
        if (state == null) {
            throw new IllegalStateException("State " + stateKey + " not exists! Make sure to setup the State Machine before change the states!");
        }
        if (onChangeState != null) {
            onChangeState.onChangeState(stateKey);
        }
        if (state.getExit() != null) {
            state.getExit().invoke();
        }
        this.performChangeState(state);
        if (state.getEnter() != null) {
            state.getEnter().invoke();
        }
        this.currentStateKey = stateKey;
    }

    public final void changeState(int stateKey, boolean forceChange) {
        this.changeState(stateKey, forceChange, this.config.onChangeState);
    }

    public final void changeState(int stateKey, @Nullable OnChangeStateCallback onChangeState) {
        this.changeState(stateKey, false, onChangeState);
    }

    public final void changeState(int stateKey) {
        this.changeState(stateKey, false);
    }

    public final StateMachine<STATE> addState(int key, @NonNull STATE state) {
        if (this.started) {
            throw new IllegalStateException("Machine already started");
        }
        if (key < 0) {
            throw new IllegalStateException("State Keys must be >= 0");
        }
        this.stateMap.put(key, state);
        return this;
    }

    public StateMachine<STATE> restoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (this.started) {
            throw new IllegalStateException("Machine already started");
        }
        if (savedInstanceState == null) {
            return this;
        }
        this.currentStateKey = savedInstanceState.getInt("STATE_MACHINE_CURRENT_KEY", this.getCurrentStateKey());
        return this;
    }

    @NonNull
    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt("STATE_MACHINE_CURRENT_KEY", this.getCurrentStateKey());
        return bundle;
    }

    public static interface OnChangeStateCallback {
        public void onChangeState(int var1);
    }

    public static abstract class State {
        @Nullable
        private Callback enter = null;
        @Nullable
        private Callback exit = null;

        public final State onEnter(@NonNull Callback callback) {
            this.enter = callback;
            return this;
        }

        public final State onExit(@NonNull Callback callback) {
            this.exit = callback;
            return this;
        }

        @Nullable
        final Callback getEnter() {
            return this.enter;
        }

        @Nullable
        final Callback getExit() {
            return this.exit;
        }

        public static interface Callback {
            public void invoke();
        }
    }

    public static final class Config {
        private int initialState = -1;
        private OnChangeStateCallback onChangeState = null;

        private Config() {
        }

        public int getInitialState() {
            return this.initialState;
        }

        public void setInitialState(int initialState) {
            if (initialState < 0) {
                throw new IllegalStateException("initialState cannot be < 0");
            }
            this.initialState = initialState;
        }

        @Nullable
        public OnChangeStateCallback getOnChangeState() {
            return this.onChangeState;
        }

        public void setOnChangeState(@Nullable OnChangeStateCallback onChangeState) {
            this.onChangeState = onChangeState;
        }
    }
}

