/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.knows.idlabFunctions.state;

import be.ugent.knows.idlabFunctions.state.SetState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInMemorySetState<T>
implements SetState<T> {
    private static final Logger log = LoggerFactory.getLogger(SimpleInMemorySetState.class);
    private final Map<String, Set<T>> stateFileToSet = new HashMap<String, Set<T>>();

    private synchronized Set<T> computeSet(String stateFilePath) {
        return this.stateFileToSet.computeIfAbsent(stateFilePath, setKey -> {
            File stateFile = new File(stateFilePath);
            Set newSet = new HashSet();
            if (stateFile.exists() && stateFile.isFile() && stateFile.canRead()) {
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFilePath)));){
                    newSet = (Set)in.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    log.warn("Cannot load state set from file {}. Creating empty set!", (Object)stateFilePath);
                }
            }
            return newSet;
        });
    }

    @Override
    public synchronized boolean contains(String stateFilePath, T value) {
        Set<T> set = this.computeSet(stateFilePath);
        return set.contains(value);
    }

    @Override
    public synchronized void saveAllState() {
        this.stateFileToSet.forEach((stateFilePath, stateSet) -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)stateFilePath, false)));){
                out.writeObject(stateSet);
            }
            catch (IOException e) {
                log.warn("Cannot save state set to {}", stateFilePath);
            }
        });
    }

    @Override
    public synchronized void deleteAllState() {
        this.stateFileToSet.forEach((stateFilePath, stateSet) -> {
            File stateFile = new File((String)stateFilePath);
            if (!stateFile.delete()) {
                log.warn("Could not delete {}", stateFilePath);
            }
        });
        this.stateFileToSet.clear();
    }

    @Override
    public void add(String stateFilePath, T value) {
        Set<T> set = this.computeSet(stateFilePath);
        set.add(value);
    }

    @Override
    public synchronized void close() {
        this.saveAllState();
        this.stateFileToSet.clear();
    }
}

