/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.dataType;

import be.ugent.idlab.knows.functions.agent.dataType.BooleanConverter;
import be.ugent.idlab.knows.functions.agent.dataType.ByteConverter;
import be.ugent.idlab.knows.functions.agent.dataType.CharacterConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DefaultDataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DoubleConverter;
import be.ugent.idlab.knows.functions.agent.dataType.FloatConverter;
import be.ugent.idlab.knows.functions.agent.dataType.IntegerConverter;
import be.ugent.idlab.knows.functions.agent.dataType.ListConverter;
import be.ugent.idlab.knows.functions.agent.dataType.LongConverter;
import be.ugent.idlab.knows.functions.agent.dataType.NumberConverter;
import be.ugent.idlab.knows.functions.agent.dataType.ShortConverter;
import be.ugent.idlab.knows.functions.agent.dataType.StringConverter;
import be.ugent.idlab.knows.functions.agent.dataType.XSBooleanConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DataTypeConverterProvider {
    private final Map<String, DataTypeConverter<?>> nameToConverter = new HashMap();

    public DataTypeConverterProvider() {
        this.addJavaConverters();
        this.addXMLSchemaConverters();
        this.addRDFConverters();
    }

    public DataTypeConverter<?> getDataTypeConverter(String type) {
        return this.nameToConverter.getOrDefault(type, new DefaultDataTypeConverter());
    }

    public DataTypeConverter<?> getDataTypeConverterWhichProcessesSubTypeOf(String type) {
        if (this.nameToConverter.containsKey(type)) {
            return this.nameToConverter.get(type);
        }
        try {
            Class<?> theClass = Class.forName(type);
            Optional<DataTypeConverter> candidate = this.nameToConverter.values().stream().filter(dataTypeConverter -> dataTypeConverter.isSubTypeOf(theClass)).findFirst();
            return candidate.orElse(new DefaultDataTypeConverter());
        }
        catch (ClassNotFoundException e) {
            return new DefaultDataTypeConverter();
        }
    }

    private void addJavaConverters() {
        this.nameToConverter.put(Object.class.getName(), new DefaultDataTypeConverter());
        this.nameToConverter.put(Byte.class.getName(), new ByteConverter());
        this.nameToConverter.put(Byte.TYPE.getName(), new ByteConverter());
        this.nameToConverter.put(Character.class.getName(), new CharacterConverter());
        this.nameToConverter.put(Character.TYPE.getName(), new CharacterConverter());
        this.nameToConverter.put(Short.class.getName(), new ShortConverter());
        this.nameToConverter.put(Short.TYPE.getName(), new ShortConverter());
        this.nameToConverter.put(Integer.class.getName(), new IntegerConverter());
        this.nameToConverter.put(Integer.TYPE.getName(), new IntegerConverter());
        this.nameToConverter.put(Long.class.getName(), new LongConverter());
        this.nameToConverter.put(Long.TYPE.getName(), new LongConverter());
        this.nameToConverter.put(Float.class.getName(), new FloatConverter());
        this.nameToConverter.put(Float.TYPE.getName(), new FloatConverter());
        this.nameToConverter.put(Double.class.getName(), new DoubleConverter());
        this.nameToConverter.put(Double.TYPE.getName(), new DoubleConverter());
        this.nameToConverter.put(Boolean.class.getName(), new BooleanConverter());
        this.nameToConverter.put(Boolean.TYPE.getName(), new BooleanConverter());
        this.nameToConverter.put(String.class.getName(), new StringConverter());
        this.nameToConverter.put(List.class.getName(), new ListConverter());
    }

    private void addXMLSchemaConverters() {
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#integer", new LongConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#int", new IntegerConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#long", new LongConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#double", new DoubleConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#decimal", new NumberConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#boolean", new XSBooleanConverter());
        this.nameToConverter.put("http://www.w3.org/2001/XMLSchema#string", new StringConverter());
    }

    public void addRDFConverters() {
        this.nameToConverter.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#List", new ListConverter());
    }
}

