/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent;

import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.NAMESPACES;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Implementation;
import be.ugent.idlab.knows.functions.agent.model.MethodMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptionGenerator {
    private static final Map<Class<?>, String> datatypeMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(DescriptionGenerator.class);
    private static final Property rdfTypeProperty = ResourceFactory.createProperty((String)NAMESPACES.RDF.toString(), (String)"type");
    private static final Property fnoNameProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"name");
    private static final Property fnoParameterProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"expects");
    private static final Property fnoReturnProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"returns");
    private static final Property fnoPredicateProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"predicate");
    private static final Property fnoRequiredProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"required");
    private static final Property fnoTypeProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"type");
    private static final Property fnoiClassNameProperty = ResourceFactory.createProperty((String)NAMESPACES.FNOI.toString(), (String)"class-name");
    private static final Property fnoFunctionProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"function");
    private static final Property fnoImplementationProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"implementation");
    private static final Property fnoMethodMappingProperty = ResourceFactory.createProperty((String)NAMESPACES.FNO.toString(), (String)"methodMapping");
    private static final Property fnomMethodNameProperty = ResourceFactory.createProperty((String)NAMESPACES.FNOM.toString(), (String)"method-name");
    private static final Property dctermsDescriptionProperty = ResourceFactory.createProperty((String)NAMESPACES.DCTERMS.toString(), (String)"description");
    private static final String BASE = "https://example.com/fno/";

    private static void addParameters(Model model, Method method, Resource function) {
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        RDFNode[] rdfArray = new RDFNode[parameters.length];
        Arrays.stream(parameters).map(parameter -> {
            Resource parameterResource = model.createResource("https://example.com/fno/Parameter#" + parameter.getName());
            parameterResource.addProperty(fnoNameProperty, parameter.getName());
            Resource predicateResource = model.createResource("https://example.com/fno/Predicate#" + parameter.getName());
            parameterResource.addProperty(fnoPredicateProperty, (RDFNode)predicateResource);
            parameterResource.addProperty(fnoRequiredProperty, "true", (RDFDatatype)XSDDatatype.XSDboolean);
            parameterResource.addProperty(fnoTypeProperty, (RDFNode)model.createResource(DescriptionGenerator.getDatatype(parameter.getType())));
            parameterResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Parameter"));
            return parameterResource;
        }).collect(Collectors.toList()).toArray(rdfArray);
        RDFList parameterList = model.createList(rdfArray);
        function.addProperty(fnoParameterProperty, (RDFNode)parameterList);
    }

    private static void addParameters(Model model, Function function, Resource functionResource) {
        List<Parameter> parameterList = function.getArgumentParameters();
        RDFNode[] rdfArray = new RDFNode[parameterList.size()];
        parameterList.stream().map(parameter -> {
            Resource parameterResource = model.createResource(function.getId() + parameter.getId());
            parameterResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Parameter"));
            return DescriptionGenerator.addCommonProperties(model, parameter, parameterResource);
        }).collect(Collectors.toList()).toArray(rdfArray);
        RDFList parameters = model.createList(rdfArray);
        functionResource.addProperty(fnoParameterProperty, (RDFNode)parameters);
    }

    private static void addReturnTypeAndExceptions(Model model, Method method, Resource function) {
        Class<?> returnType = method.getReturnType();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        int offset = "void".equals(returnType.getName()) ? 0 : 1;
        RDFNode[] returnList = new RDFNode[exceptionTypes.length + offset];
        if (!"void".equals(returnType.getName())) {
            Resource returnTypeResource = model.createResource("https://example.com/fno/Output#" + returnType.getName());
            returnTypeResource.addProperty(fnoNameProperty, returnType.getName() + "Output");
            returnTypeResource.addProperty(fnoRequiredProperty, "true", (RDFDatatype)XSDDatatype.XSDboolean);
            returnTypeResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Output"));
            returnTypeResource.addProperty(fnoTypeProperty, (RDFNode)model.createResource(DescriptionGenerator.getDatatype(returnType)));
            returnTypeResource.addProperty(fnoPredicateProperty, (RDFNode)model.createResource("https://example.com/fno/PredicateOutput#" + returnType.getName()));
            returnList[0] = returnTypeResource;
        }
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            Resource exceptionResource = model.createResource("https://example.com/fno/Exception#" + exceptionType.getName());
            exceptionResource.addProperty(fnoNameProperty, exceptionType.getName() + "Exception");
            exceptionResource.addProperty(fnoRequiredProperty, "false");
            exceptionResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Output"));
            exceptionResource.addProperty(fnoTypeProperty, (RDFNode)model.createResource(DescriptionGenerator.getDatatype(exceptionType)));
            exceptionResource.addProperty(fnoPredicateProperty, (RDFNode)model.createResource("https://example.com/fno/PredicateOutput#" + exceptionType.getName()));
            returnList[i + offset] = exceptionResource;
        }
        RDFList outputList = model.createList(returnList);
        function.addProperty(fnoReturnProperty, (RDFNode)outputList);
    }

    private static void addReturnTypeAndExceptions(Model model, Function function, Resource functionResource) {
        List<Parameter> returnParameterList = function.getReturnParameters();
        RDFNode[] rdfArray = new RDFNode[returnParameterList.size()];
        returnParameterList.stream().map(returnType -> {
            Resource returnResource = model.createResource(function.getId() + returnType.getId());
            returnResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Output"));
            return DescriptionGenerator.addCommonProperties(model, returnType, returnResource);
        }).collect(Collectors.toList()).toArray(rdfArray);
        RDFList parameters = model.createList(rdfArray);
        functionResource.addProperty(fnoReturnProperty, (RDFNode)parameters);
    }

    private static Resource addCommonProperties(Model model, Parameter returnType, Resource returnResource) {
        returnResource.addProperty(fnoNameProperty, returnType.getName());
        Resource predicateResource = model.createResource(returnType.getId());
        returnResource.addProperty(fnoPredicateProperty, (RDFNode)predicateResource);
        returnResource.addProperty(fnoRequiredProperty, "" + returnType.isRequired());
        returnResource.addProperty(fnoTypeProperty, (RDFNode)model.createResource(DescriptionGenerator.getDatatype(returnType.getTypeConverter().getTypeClass())));
        return returnResource;
    }

    private static void addMapping(Model model, Method method, Resource function) {
        Class<?> clazz = method.getDeclaringClass();
        Resource classResource = model.createResource("https://example.com/fno/JavaClass#" + clazz.getName());
        classResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNOI + "JavaClass"));
        classResource.addProperty(fnoiClassNameProperty, clazz.getName());
        Resource mappingResource = model.createResource("https://example.com/fno/Mapping#" + method.getName());
        mappingResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Mapping"));
        mappingResource.addProperty(fnoFunctionProperty, (RDFNode)function);
        mappingResource.addProperty(fnoImplementationProperty, (RDFNode)classResource);
        Resource methodMappingResource = model.createResource();
        methodMappingResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNOM + "StringMethodMapping"));
        methodMappingResource.addProperty(fnomMethodNameProperty, method.getName());
        mappingResource.addProperty(fnoMethodMappingProperty, (RDFNode)methodMappingResource);
    }

    private static void addMapping(Model model, Function function, Resource functionResource) {
        if (function.isComposite()) {
            return;
        }
        FunctionMapping functionMapping = function.getFunctionMapping();
        MethodMapping methodMapping = functionMapping.getMethodMapping();
        Implementation implementation = functionMapping.getImplementation();
        Resource classResource = model.createResource("https://example.com/fno/JavaClass#" + implementation.getClassName());
        classResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNOI + "JavaClass"));
        classResource.addProperty(fnoiClassNameProperty, implementation.getClassName());
        Resource mappingResource = model.createResource(function.getId() + "Mapping");
        mappingResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Mapping"));
        mappingResource.addProperty(fnoFunctionProperty, (RDFNode)functionResource);
        mappingResource.addProperty(fnoImplementationProperty, (RDFNode)classResource);
        Resource methodMappingResource = model.createResource();
        methodMappingResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(methodMapping.getType()));
        methodMappingResource.addProperty(fnomMethodNameProperty, methodMapping.getMethodName());
        mappingResource.addProperty(fnoMethodMappingProperty, (RDFNode)methodMappingResource);
    }

    public static String generateDescription(Model model, Method method) {
        logger.debug("name: {}", (Object)method.getName());
        String methodURI = "https://example.com/fno/Function#" + method.getDeclaringClass().getName() + "." + method.getName();
        Resource function = model.createResource(methodURI);
        function.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Function"));
        function.addProperty(fnoNameProperty, method.getName());
        function.addProperty(dctermsDescriptionProperty, method.getName());
        DescriptionGenerator.addParameters(model, method, function);
        DescriptionGenerator.addReturnTypeAndExceptions(model, method, function);
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            DescriptionGenerator.addMapping(model, method, function);
        }
        return methodURI;
    }

    public static void addFunctionToModel(Model model, Function function) {
        String functionURI = function.getId();
        Resource functionResource = model.createResource(functionURI);
        functionResource.addProperty(rdfTypeProperty, (RDFNode)model.createResource(NAMESPACES.FNO + "Function"));
        functionResource.addProperty(fnoNameProperty, function.getName());
        functionResource.addProperty(dctermsDescriptionProperty, function.getDescription());
        DescriptionGenerator.addParameters(model, function, functionResource);
        DescriptionGenerator.addReturnTypeAndExceptions(model, function, functionResource);
        if (function.isComposite()) {
            logger.warn("Function composition not implemented yet! Skipping function {} ({})", (Object)function.getId(), (Object)function.getName());
        } else {
            DescriptionGenerator.addMapping(model, function, functionResource);
        }
    }

    private static String getDatatype(Class<?> clazz) {
        logger.debug("getting data type for {}", (Object)clazz.getName());
        if (!datatypeMap.containsKey(clazz)) {
            logger.debug("no entry found, returning default value XSDanyURI");
        }
        return datatypeMap.getOrDefault(clazz, XSDDatatype.XSDanyURI.getURI());
    }

    static {
        datatypeMap.put(Boolean.TYPE, XSDDatatype.XSDboolean.getURI());
        datatypeMap.put(Boolean.class, XSDDatatype.XSDboolean.getURI());
        datatypeMap.put(String.class, XSDDatatype.XSDstring.getURI());
        datatypeMap.put(Integer.TYPE, XSDDatatype.XSDint.getURI());
        datatypeMap.put(Integer.class, XSDDatatype.XSDint.getURI());
        datatypeMap.put(Long.TYPE, XSDDatatype.XSDinteger.getURI());
        datatypeMap.put(Long.class, XSDDatatype.XSDinteger.getURI());
        datatypeMap.put(Float.TYPE, XSDDatatype.XSDdecimal.getURI());
        datatypeMap.put(Float.class, XSDDatatype.XSDdecimal.getURI());
        datatypeMap.put(Double.TYPE, XSDDatatype.XSDfloat.getURI());
        datatypeMap.put(Double.class, XSDDatatype.XSDfloat.getURI());
        datatypeMap.put(Object[].class, NAMESPACES.RDF + "list");
    }
}

