/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.AgentImpl;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.Instantiator;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.FnOFunctionModelProvider;
import be.ugent.idlab.knows.functions.agent.functionModelProvider.fno.exception.FnOException;
import be.ugent.idlab.knows.functions.agent.model.Function;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentFactory {
    private static final Logger logger = LoggerFactory.getLogger(AgentFactory.class);

    public static Agent createFromFnO(String ... pathToFnoDocs) throws FnOException {
        return AgentFactory.createFromFnO(Collections.emptyMap(), pathToFnoDocs);
    }

    public static Agent createFromFnO(Map<String, String> implementationLocationMap, String ... pathToFnoDocs) throws FnOException {
        logger.debug("Initialising DataTypeConverterProvider...");
        DataTypeConverterProvider dataTypeConverterProvider = new DataTypeConverterProvider();
        logger.debug("DataTypeConverterProvider initialised!");
        logger.debug("Initialising FunctionModelProvider...");
        FnOFunctionModelProvider functionModelProvider = new FnOFunctionModelProvider(dataTypeConverterProvider, implementationLocationMap, pathToFnoDocs);
        logger.debug("FunctionModelProvider initialised!");
        Map<String, Function> functionId2Function = functionModelProvider.getFunctions();
        logger.debug("Initialising Instantiator...");
        Instantiator instantiator = new Instantiator(functionId2Function, dataTypeConverterProvider);
        logger.debug("Instantiator initialised!");
        logger.debug("Initialising AgentImpl...");
        AgentImpl agent = new AgentImpl(functionId2Function, instantiator);
        logger.debug("AgentImpl initialised!");
        return agent;
    }
}

