/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.streams;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.record.ExcelRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.streams.SourceStream;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelSourceStream
implements SourceStream {
    private static final long serialVersionUID = -5883688877961394710L;
    private final Access access;
    private transient Iterator<Sheet> iterator;
    private transient Workbook wb;
    private Row header;

    public ExcelSourceStream(Access access) throws Exception {
        this.access = access;
        this.bootstrap();
    }

    private void bootstrap() throws Exception {
        try (InputStream in = this.access.getInputStream();){
            this.wb = StreamingReader.builder().open(in);
            this.iterator = this.wb.iterator();
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.bootstrap();
    }

    @Override
    public Stream<Record> getStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator, 16), false).peek(sheet -> {
            this.header = (Row)sheet.iterator().next();
        }).flatMap(this::getRowStreamFromSheet).skip(1L).map(row -> new ExcelRecord(this.header, (Row)row));
    }

    private Stream<Row> getRowStreamFromSheet(Sheet sheet) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(sheet.rowIterator(), 16), true);
    }

    @Override
    public void close() throws IOException {
        this.wb.close();
    }
}

