/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.record;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import java.util.List;
import java.util.Objects;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLRecord
extends Record {
    private final Element element;
    private final List<String> headers;

    public HTMLRecord(Element element, List<String> headers) {
        this.element = element;
        this.headers = headers;
    }

    @Override
    public RecordValue get(String reference) {
        int index = this.headers.indexOf(reference);
        if (index == -1) {
            return RecordValue.notFound(String.format("Mapping for %s not found, expected one of %s", reference, this.headers));
        }
        Elements tr = this.element.select("tr");
        if (tr.isEmpty()) {
            return RecordValue.notFound(String.format("Mapping for %s not found, expected one of %s", reference, this.headers));
        }
        Elements td = ((Element)tr.get(0)).select("td");
        if (td.size() <= index) {
            return RecordValue.empty();
        }
        return RecordValue.ok(((Element)td.get(index)).text());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTMLRecord o = (HTMLRecord)obj;
        return (this.element != null && this.element.text().equals(o.element.text()) || this.element == null && o.element == null) && (this.headers != null && this.headers.equals(o.headers) || this.headers == null && o.headers == null);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.headers);
    }
}

