/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators.csvw;

import be.ugent.idlab.knows.dataio.iterators.csvw.CSVWConfigurationBuilder;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.lightningcsv.CsvParser;

public final class CSVWConfiguration
implements Serializable {
    private static final long serialVersionUID = -5750213407136895070L;
    public static CSVWConfiguration DEFAULT = CSVWConfiguration.builder().build();
    private final char delimiter;
    private final char escapeCharacter;
    private final String trim;
    private final char quoteCharacter;
    private final boolean skipHeader;
    private final String commentPrefix;
    private final List<String> header;
    private final List<String> nulls;
    private final String encoding;

    CSVWConfiguration(char delimiter, char escapeCharacter, String trim, char quoteCharacter, boolean skipHeader, String commentPrefix, List<String> header, List<String> nulls, Charset encoding) {
        this.delimiter = delimiter;
        this.escapeCharacter = escapeCharacter;
        this.quoteCharacter = quoteCharacter;
        this.trim = trim;
        this.skipHeader = skipHeader;
        this.commentPrefix = commentPrefix;
        this.header = header;
        ArrayList<String> nullValues = new ArrayList<String>(nulls);
        nullValues.add("DATAIO_NULL");
        this.nulls = nullValues;
        this.encoding = encoding.name();
    }

    public static CSVWConfigurationBuilder builder() {
        return new CSVWConfigurationBuilder();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String getTrim() {
        return this.trim;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<String> getNulls() {
        return this.nulls;
    }

    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }

    public CsvParser.DSL getSFMParser(int bufferSize) {
        return (CsvParser.DSL)((CsvParser.DSL)((CsvParser.DSL)CsvParser.separator((char)this.delimiter).escape(this.escapeCharacter)).quote(this.quoteCharacter)).bufferSize(bufferSize);
    }
}

