/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.exceptions.HeaderEmptyValuesException;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.ODSRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;

public class ODSSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = 4036007304900261485L;
    private final Access access;
    private transient Iterator<ODSRecord> records;

    public ODSSourceIterator(Access access) throws Exception {
        this.access = access;
        this.bootstrap();
    }

    private void readObject(ObjectInputStream inputStream) throws Exception {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    private void bootstrap() throws Exception {
        ArrayList<ODSRecord> sources = new ArrayList<ODSRecord>();
        try (InputStream is = this.access.getInputStream();){
            SpreadsheetDocument document;
            try {
                document = SpreadsheetDocument.loadDocument((InputStream)is);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            List tables = document.getTableList();
            for (Table t : tables) {
                int i;
                Row header = t.getRowByIndex(0);
                for (i = 0; i < header.getCellCount(); ++i) {
                    if (!header.getCellByIndex(i).getStringValue().isEmpty()) continue;
                    throw new HeaderEmptyValuesException(this.access.getAccessPath());
                }
                for (i = 1; i < t.getRowList().size(); ++i) {
                    Row row = t.getRowByIndex(i);
                    sources.add(new ODSRecord(header, row));
                }
            }
            this.records = sources.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public Record next() {
        return this.records.next();
    }

    @Override
    public void close() {
    }
}

