/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.JSONSourceIterator;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.Record;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JSONLinesSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = -6863412600310339167L;
    private final Access access;
    private final String iteratorPath;
    private transient LineIterator lineIterator;
    private transient JSONSourceIterator iterator;

    public JSONLinesSourceIterator(Access access, String iteratorPath) throws Exception {
        this.access = access;
        this.iteratorPath = iteratorPath;
        this.bootstrap();
    }

    private void readObject(ObjectInputStream inputStream) throws Exception {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    private void bootstrap() throws Exception {
        this.lineIterator = new LineIterator(this.access.getInputStream());
    }

    @Override
    public boolean hasNext() {
        while (this.iterator == null || !this.iterator.hasNext()) {
            if (this.lineIterator.hasNext()) {
                String line = this.lineIterator.next();
                try {
                    this.iterator = new JSONSourceIterator(line, this.iteratorPath);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Record next() {
        if (this.hasNext()) {
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws IOException {
        this.lineIterator.close();
    }

    private static class LineIterator
    implements Iterator<String>,
    AutoCloseable {
        private final BufferedReader reader;
        private String currentLine = null;

        public LineIterator(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public boolean hasNext() {
            return this.currentLine != null || this.read() && this.currentLine != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String line = this.currentLine;
                this.currentLine = null;
                return line;
            }
            throw new NoSuchElementException();
        }

        private boolean read() {
            try {
                if (this.reader.ready()) {
                    this.currentLine = this.reader.readLine();
                    return true;
                }
                this.currentLine = null;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

