/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.iterators;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.HTMLRecord;
import be.ugent.idlab.knows.dataio.record.Record;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class HTMLSourceIterator
extends SourceIterator {
    private static final long serialVersionUID = -79397539726939643L;
    private final Access access;
    private final String stringIterator;
    private transient Iterator<Element> iterator;
    private transient List<String> headers;

    public HTMLSourceIterator(Access access, String stringIterator) throws Exception {
        this.access = access;
        this.stringIterator = stringIterator;
        this.bootstrap();
    }

    private void bootstrap() throws Exception {
        try (InputStream inputStream = this.access.getInputStream();){
            this.iterator = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"http://example.com/").select(this.stringIterator).iterator();
            if (this.iterator.hasNext()) {
                this.headers = this.iterator.next().select("th").stream().map(Element::text).collect(Collectors.toList());
            }
        }
    }

    private void readObject(ObjectInputStream inputStream) throws Exception {
        inputStream.defaultReadObject();
        this.bootstrap();
    }

    @Override
    public Record next() {
        if (this.hasNext()) {
            return new HTMLRecord(this.iterator.next(), this.headers);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws IOException {
    }
}

