/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.utils.Utils;
import com.jayway.jsonpath.Configuration;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WoTAccess
implements Access {
    private static final Logger logger = LoggerFactory.getLogger(WoTAccess.class);
    private static final long serialVersionUID = -1098654761923880385L;
    private final Map<String, Map<String, String>> auth;
    private final String location;
    private final String contentType;
    private final Map<String, String> headers;

    public WoTAccess(String location, String contentType, Map<String, String> headers, Map<String, Map<String, String>> auth) {
        this.location = location;
        this.contentType = contentType;
        this.headers = headers;
        this.auth = auth;
        logger.debug("Created WoTAccess:\n\tlocation: {}\n\tcontent-type: {}", (Object)this.location, (Object)this.contentType);
        logger.debug(headers.toString());
        headers.forEach((name, value) -> logger.debug("Header: {} : {}", name, value));
    }

    @Override
    public InputStream getInputStream() throws Exception {
        logger.debug("get input stream");
        if (this.auth.get("data").containsKey("refresh")) {
            try {
                return Utils.getInputStreamFromURL(new URL(this.location), this.contentType, this.headers);
            }
            catch (Exception e) {
                logger.debug("Refresh token");
                this.refreshToken();
                logger.debug("try again with new token");
                logger.debug("new token = {}", (Object)this.headers.get(this.auth.get("info").get("name")));
                return Utils.getInputStreamFromURL(new URL(this.location), this.contentType, this.headers);
            }
        }
        return Utils.getInputStreamFromURL(new URL(this.location), this.contentType, this.headers);
    }

    @Override
    public Map<String, String> getDataTypes() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof WoTAccess) {
            WoTAccess access = (WoTAccess)o;
            return this.location.equals(access.getLocation()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getLocation() + this.getContentType());
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccessPath() {
        return this.location;
    }

    private void refreshToken() throws Exception {
        StringBuilder data = new StringBuilder();
        data.append("{\"grant_type\": \"refresh_token\"");
        for (String name : this.auth.get("data").keySet()) {
            data.append(" ,\"").append(name).append("\":\"").append(this.auth.get("data").get(name)).append("\"");
        }
        data.append("}");
        logger.debug(data.toString());
        InputStream response = this.getPostRequestResponse(new URL(this.auth.get("info").get("authorization")), this.contentType, data.toString().getBytes());
        Map jsonResponse = (Map)Configuration.defaultConfiguration().jsonProvider().parse(response, "utf-8");
        this.headers.put(this.auth.get("info").get("name"), "Bearer " + (String)jsonResponse.get("access_token"));
    }

    private InputStream getPostRequestResponse(URL url, String contentType, byte[] auth) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", contentType);
        connection.setRequestProperty("charset", "utf-8");
        connection.connect();
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(auth);
        return connection.getInputStream();
    }
}

