/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.utils.Utils;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class RemoteFileAccess
implements Access {
    private static final long serialVersionUID = -681410592061545964L;
    private final String location;
    private final String contentType;

    public RemoteFileAccess(String location) {
        this(location, "");
    }

    public RemoteFileAccess(String location, String contentType) {
        this.location = location;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return Utils.getInputStreamFromURL(new URL(this.location), this.contentType);
    }

    @Override
    public Map<String, String> getDataTypes() {
        return Map.of();
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFileAccess) {
            RemoteFileAccess access = (RemoteFileAccess)o;
            return this.location.equals(access.getLocation()) && this.contentType.equals(access.getContentType());
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getLocation() + this.getContentType());
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccessPath() {
        return this.location;
    }
}

