/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.dataio.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileAccess
implements Access {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileAccess.class);
    private static final int CONFIDENCE_LIMIT = 90;
    private static final long serialVersionUID = -4721057992645925809L;
    private final String path;
    private String type;
    private final String encoding;

    public LocalFileAccess(String path, String base, String type, Charset encoding) {
        if (base != null && !base.isEmpty()) {
            Path basePath = Path.of(base, new String[0]);
            this.path = basePath.resolve(path).toString();
        } else {
            this.path = Path.of(path, new String[0]).toString();
        }
        this.encoding = encoding.name();
        this.type = type;
    }

    public LocalFileAccess(String path, String basePath, String type) {
        this(path, basePath, type, StandardCharsets.UTF_8);
    }

    public LocalFileAccess(String path, String basePath) {
        this(path, basePath, null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Path path = Path.of(this.path, new String[0]);
        return ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(path, StandardOpenOption.READ))).get();
    }

    @Override
    public Map<String, String> getDataTypes() {
        return Collections.singletonMap(this.getAccessPath(), this.type);
    }

    public boolean equals(Object o) {
        if (o instanceof LocalFileAccess) {
            LocalFileAccess access = (LocalFileAccess)o;
            boolean sameType = this.type == null ? access.type == null : this.type.equals(access.type);
            return this.path.equals(access.path) && sameType && this.encoding.equals(access.encoding);
        }
        return false;
    }

    public int hashCode() {
        return Utils.getHashOfString(this.getAccessPath());
    }

    public Path getPath() {
        return Path.of(this.path, new String[0]);
    }

    public String toString() {
        return this.getAccessPath();
    }

    @Override
    public String getContentType() {
        if (this.type == null) {
            try {
                this.type = Files.probeContentType(Path.of(this.path, new String[0]));
            }
            catch (IOException e) {
                logger.warn("Could not get content type for path {}", (Object)this.path, (Object)e);
            }
        }
        return this.type;
    }

    @Override
    public String getAccessPath() {
        return Path.of(this.path, new String[0]).toAbsolutePath().toString();
    }

    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }
}

