/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.full;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import at.favre.lib.planb.PlanB;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.full.CrashExplorerDetailActivity;
import at.favre.lib.planb.full.R;
import at.favre.lib.planb.full.util.CrashDataExceptionComparator;
import at.favre.lib.planb.full.util.ViewUtil;
import at.favre.lib.planb.util.CrashDataUtil;
import java.util.Collections;
import java.util.List;

public class CrashExplorerOverviewActivity
extends AppCompatActivity {
    private static final String TAG = CrashExplorerOverviewActivity.class.getName();
    private static final String KEY_SORT = "SORT";
    private static final int SORT_DATE = 0;
    private static final int SORT_EXCEPTION_NAME = 1;
    private RecyclerView recyclerView;
    private List<CrashData> crashDataList;
    private int currentSort = 0;
    private Menu menu;

    public static void start(Context context) {
        Intent starter = new Intent(context, CrashExplorerOverviewActivity.class);
        context.startActivity(starter);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.currentSort = savedInstanceState.getInt(KEY_SORT, 0);
        }
        this.setContentView(R.layout.planblib_activity_crashexplorer_overview);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.toolbar).findViewById(R.id.toolbar));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(false);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)new CrashDataAdapter());
        this.updateRecyclerView();
    }

    private void updateRecyclerView() {
        this.crashDataList = PlanB.get().getCrashDataHandler().getAll();
        ((CrashDataAdapter)this.recyclerView.getAdapter()).setCrashDataList(this.crashDataList, this.currentSort);
        if (this.crashDataList.isEmpty()) {
            this.findViewById(R.id.empty_view).setVisibility(0);
        } else {
            this.findViewById(R.id.empty_view).setVisibility(8);
        }
        this.getSupportActionBar().setTitle((CharSequence)(this.getTitle() + " (" + this.crashDataList.size() + ")"));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.menu = menu2;
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.planblib_menu_overview, menu2);
        this.setSortMenuState(menu2, this.currentSort);
        ViewUtil.tintMenuItem(menu2, R.id.action_delete, -1);
        ViewUtil.tintMenuItem(menu2, R.id.action_log, -1);
        ViewUtil.tintMenuItem(menu2, R.id.action_sort, -1);
        return true;
    }

    private void setSortMenuState(Menu menu2, int sortType) {
        if (sortType == 0) {
            menu2.findItem(R.id.action_sort_date).setChecked(true);
            menu2.findItem(R.id.action_sort_exception).setChecked(false);
        } else if (sortType == 1) {
            menu2.findItem(R.id.action_sort_date).setChecked(false);
            menu2.findItem(R.id.action_sort_exception).setChecked(true);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_delete) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Delete All").setMessage((CharSequence)"Do you want to delete all the saved crash data?").setPositiveButton((CharSequence)"Delete", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PlanB.get().getCrashDataHandler().clear();
                    CrashExplorerOverviewActivity.this.updateRecyclerView();
                }
            }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
        } else if (i == R.id.action_log) {
            Log.w((String)TAG, (String)CrashDataUtil.getLogString(this.crashDataList).toString());
            Toast.makeText((Context)this, (int)R.string.planb_crashexplorer_toast_log, (int)0).show();
        } else if (i == R.id.action_sort_date || i == R.id.action_sort_exception) {
            if (i == R.id.action_sort_date) {
                this.currentSort = 0;
            }
            if (i == R.id.action_sort_exception) {
                this.currentSort = 1;
            }
            this.setSortMenuState(this.menu, this.currentSort);
            this.updateRecyclerView();
        }
        return true;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SORT, this.currentSort);
    }

    private static class CrashDataHolder
    extends RecyclerView.ViewHolder {
        TextView timestamp;
        TextView exception;
        TextView message;
        CrashData crashData;
        View root;

        public CrashDataHolder(final View itemView) {
            super(itemView);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CrashExplorerDetailActivity.start(itemView.getContext(), CrashDataHolder.this.crashData);
                }
            });
            this.root = itemView.findViewById(R.id.root_inc);
            this.timestamp = (TextView)itemView.findViewById(R.id.timestamp);
            this.exception = (TextView)itemView.findViewById(R.id.exception);
            this.message = (TextView)itemView.findViewById(R.id.message);
        }
    }

    public static class CrashDataAdapter
    extends RecyclerView.Adapter<CrashDataHolder> {
        private List<CrashData> crashDataList;

        public void setCrashDataList(List<CrashData> crashDataList, int sortType) {
            this.crashDataList = crashDataList;
            if (sortType == 1) {
                Collections.sort(crashDataList, new CrashDataExceptionComparator());
            } else {
                Collections.sort(crashDataList);
            }
            this.notifyDataSetChanged();
        }

        public CrashDataHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new CrashDataHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.planblib_inc_crashitem, parent, false));
        }

        public void onBindViewHolder(CrashDataHolder holder, int position) {
            CrashData cd = this.crashDataList.get(position);
            holder.timestamp.setText((CharSequence)CrashDataUtil.parseDate((long)cd.timestamp));
            holder.exception.setText((CharSequence)CrashDataUtil.getClassNameForException((String)cd.throwableClassName));
            holder.message.setText((CharSequence)cd.message);
            holder.crashData = cd;
            long diff = System.currentTimeMillis() - cd.timestamp;
            if (diff < 21600000L) {
                holder.timestamp.setTypeface(null, 1);
                holder.exception.setTypeface(Typeface.MONOSPACE, 1);
                holder.message.setTypeface(null, 1);
            } else {
                holder.timestamp.setTypeface(null, 0);
                holder.exception.setTypeface(Typeface.MONOSPACE, 0);
                holder.message.setTypeface(null, 0);
            }
        }

        public int getItemCount() {
            return this.crashDataList.size();
        }
    }
}

