package app.raybritton.elog.data

import android.content.Context
import android.os.Build
import app.raybritton.elog.ELog
import app.raybritton.elog.arch.LogModule
import kotlin.random.Random

internal object LogPreferences {
    private const val PREF_DEVICE_ID = "device_id.str"

    private val prefs by lazy {
        LogModule.context.getSharedPreferences("elog.prefs", Context.MODE_PRIVATE)
    }

    internal var deviceId: String
        set(value) {
            prefs.edit().putString(PREF_DEVICE_ID, value).apply()
        }
        get() {
            var token = prefs.getString(PREF_DEVICE_ID, ELog.deviceId)

            if (token.isNullOrEmpty()) {
                token = generateDeviceId()
                prefs.edit().putString(PREF_DEVICE_ID, token).apply()
            }

            return token
        }

    private fun generateDeviceId(): String {
        val inputChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()
        val id = (0..10).map { inputChars[Random.nextInt(inputChars.size)] }.joinToString("")
        return Build.MANUFACTURER + "_" + Build.MODEL + "_" + id
    }
}