/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.elog.data;

import app.raybritton.elog.ELog;
import app.raybritton.elog.ELogConfig;
import app.raybritton.elog.data.LogDatabase;
import app.raybritton.elog.data.LogFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapp/raybritton/elog/data/LogManager;", "", "()V", "db", "Lapp/raybritton/elog/data/LogDatabase;", "cleanupLogs", "", "cleanupLogs$lib_release", "createLog", "Ljava/io/File;", "createLog$lib_release", "deleteAll", "deleteAll$lib_release", "deleteLog", "id", "", "deleteLog$lib_release", "getCurrentLog", "Lapp/raybritton/elog/data/LogFile;", "getCurrentLog$lib_release", "getLogs", "", "getLogs$lib_release", "setCodeForLog", "logFile", "code", "setCodeForLog$lib_release", "lib_release"})
public final class LogManager {
    private final LogDatabase db = new LogDatabase();

    @NotNull
    public final List<LogFile> getLogs$lib_release() {
        return this.db.getLogs$lib_release();
    }

    @Nullable
    public final LogFile getCurrentLog$lib_release() {
        return this.db.getLatestLog();
    }

    public final void setCodeForLog$lib_release(@NotNull LogFile logFile, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        LogFile updated = LogFile.copy$default(logFile, null, null, 0L, code, 7, null);
        this.db.updateLog$lib_release(updated);
    }

    @NotNull
    public final File createLog$lib_release() {
        File dir = ELog.INSTANCE.getLogDir$lib_release();
        File file = new File(dir, UUID.randomUUID().toString());
        while (file.exists()) {
            file = new File(dir, UUID.randomUUID().toString());
        }
        if (file.createNewFile()) {
            LogFile logFile = new LogFile(FilesKt.getNameWithoutExtension((File)file), file, System.currentTimeMillis(), null);
            this.db.insertLog$lib_release(logFile);
            return file;
        }
        throw (Throwable)new IllegalStateException("Unable to create new log files");
    }

    public final void deleteLog$lib_release(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.db.deleteLog$lib_release(id);
        new File(ELog.INSTANCE.getLogDir$lib_release(), id).delete();
    }

    public final void cleanupLogs$lib_release() {
        LogFile it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        long maxUnsubmittedAge = System.currentTimeMillis() - (long)ELogConfig.INSTANCE.getMaxUnsubmittedLogAgeMs();
        long maxSubmittedAge = System.currentTimeMillis() - ELogConfig.INSTANCE.getMaxSubmittedLogAgeMs();
        List<LogFile> logs = this.getLogs$lib_release();
        Iterable $this$filter$iv = logs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (LogFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getCode() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (LogFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getCreated() < maxUnsubmittedAge)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogFile it2 = (LogFile)element$iv;
            boolean bl = false;
            this.deleteLog$lib_release(it2.getId());
        }
        $this$filter$iv = logs;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (LogFile)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getCode() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (LogFile)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getCreated() < maxSubmittedAge)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogFile it3 = (LogFile)element$iv;
            boolean bl4 = false;
            this.deleteLog$lib_release(it3.getId());
        }
        $this$filter$iv = logs;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl4 = $this$filterTo$iv$iv.iterator();
        while (bl4.hasNext()) {
            element$iv$iv = bl4.next();
            it = (LogFile)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getFile().length() == 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogFile it4 = (LogFile)element$iv;
            boolean bl6 = false;
            this.deleteLog$lib_release(it4.getId());
        }
    }

    public final void deleteAll$lib_release() {
        this.db.deleteAll$lib_release();
        File[] fileArray = ELog.INSTANCE.getLogDir$lib_release().listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                it.delete();
            }
        }
    }
}

