/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.elog.data;

import app.raybritton.elog.ELog;
import app.raybritton.elog.ELogConfig;
import app.raybritton.elog.arch.LogModule;
import app.raybritton.elog.data.ELogTree;
import app.raybritton.elog.data.LogFile;
import app.raybritton.elog.data.LogUpload;
import app.raybritton.elog.data.Result;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\r0\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lapp/raybritton/elog/data/LogUpload;", "", "()V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "okhttp", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "getOkhttp", "()Lokhttp3/OkHttpClient;", "okhttp$delegate", "Lkotlin/Lazy;", "upload", "", "log", "Lapp/raybritton/elog/data/LogFile;", "code", "", "onComplete", "Lkotlin/Function1;", "Lapp/raybritton/elog/data/Result;", "Lkotlin/ParameterName;", "name", "result", "lib_release"})
public final class LogUpload {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.UK);
    private final Lazy okhttp$delegate = LazyKt.lazy((Function0)okhttp.2.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LogUpload.class), "okhttp", "getOkhttp()Lokhttp3/OkHttpClient;"))};
    }

    private final OkHttpClient getOkhttp() {
        Lazy lazy = this.okhttp$delegate;
        LogUpload logUpload = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    public final void upload(@NotNull LogFile log, @NotNull String code, @NotNull Function1<? super Result, Unit> onComplete) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
        if (StringsKt.isBlank((CharSequence)ELog.INSTANCE.getUploadServerUrl$lib_release())) {
            throw (Throwable)new IllegalStateException("uploadServerUrl has not been set");
        }
        if (StringsKt.isBlank((CharSequence)ELogConfig.INSTANCE.getApiPath())) {
            throw (Throwable)new IllegalStateException("apiPath has not been set");
        }
        MediaType mediaType = MediaType.get((String)"text/plain");
        RequestBody body = RequestBody.create((MediaType)mediaType, (File)log.getFile());
        Request request = new Request.Builder().url(ELog.INSTANCE.getUploadServerUrl$lib_release() + ELogConfig.INSTANCE.getApiPath()).header("x-code", code).header("x-version", ELog.INSTANCE.getAppVersionName()).header("x-version-code", String.valueOf(ELog.INSTANCE.getAppVersion())).header("x-app", ELog.INSTANCE.getAppPackage()).header("x-build", ELog.INSTANCE.getAppBuild()).header("x-created", this.dateFormatter.format(new Date(log.getCreated()))).post(body).build();
        this.getOkhttp().newCall(request).enqueue(new Callback(onComplete, log, code){
            final /* synthetic */ Function1 $onComplete;
            final /* synthetic */ LogFile $log;
            final /* synthetic */ String $code;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onComplete.invoke((Object)new Result.Error(e));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (Intrinsics.areEqual((Object)this.$log.getFile().getAbsolutePath(), (Object)ELogTree.Companion.getFile$lib_release().getAbsolutePath())) {
                        ELogTree.Companion.setFile$lib_release(LogModule.INSTANCE.getLogManager$lib_release().createLog$lib_release());
                    }
                    this.$onComplete.invoke((Object)new Result.Success(this.$code));
                } else {
                    this.$onComplete.invoke((Object)new Result.Error(new IOException("" + response.code() + ' ' + response.message())));
                }
            }
            {
                this.$onComplete = $captured_local_variable$0;
                this.$log = $captured_local_variable$1;
                this.$code = $captured_local_variable$2;
            }
        });
    }

    public static /* synthetic */ void upload$default(LogUpload logUpload, LogFile logFile, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = ELog.generateCode$lib_release$default(ELog.INSTANCE, null, 1, null);
        }
        logUpload.upload(logFile, string, (Function1<? super Result, Unit>)function1);
    }
}

