package app.raybritton.elog.ui

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.*
import android.widget.TextView
import androidx.recyclerview.widget.DefaultItemAnimator
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import app.raybritton.elog.ELogConfig
import app.raybritton.elog.R
import app.raybritton.elog.data.LogFile
import kotlinx.android.synthetic.main.elog_activity_log_list.*
import kotlinx.android.synthetic.main.elog_activity_log_viewer.*
import kotlin.concurrent.thread
import kotlin.math.log

class LogViewerActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.elog_activity_log_viewer)
        elog_view_toolbar.setBackgroundColor(ELogConfig.toolbarBackgroundColor)
        elog_view_toolbar.setTitleTextColor(ELogConfig.toolbarForegroundColor)
        setStatusBarColor(ELogConfig.toolbarBackgroundColor)

        val logFile = intent.getSerializableExtra(ARG_LOG_FILE) as LogFile

        setActionBar(elog_view_toolbar)
        actionBar?.setTitle(R.string.elog_view_title)
        actionBar?.setDisplayHomeAsUpEnabled(true)
        actionBar?.setDisplayShowHomeEnabled(true)
        actionBar?.setHomeAsUpIndicator(R.drawable.elog_ic_close)

        elog_view_content.layoutManager = LinearLayoutManager(this)
        elog_view_content.itemAnimator = DefaultItemAnimator()
        thread {
            val lines = logFile.file.readLines()
            runOnUiThread {
                elog_view_content.adapter = LogAdapter(lines)
            }
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.elog_share, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when(item.itemId) {
            android.R.id.home -> finish()
            R.id.elog_action_share -> {
                val logFile = intent.getSerializableExtra(ARG_LOG_FILE) as LogFile
                if (logFile.code == null) {
                    LogSubmitActivity.start(this, logFile)
                } else {
                    AlreadySentActivity.start(this, logFile.code)
                }
            }
        }
        return super.onOptionsItemSelected(item)
    }

    private class LogAdapter(private val logLines: List<String>) :
        RecyclerView.Adapter<LogAdapter.LogLineViewHolder>() {

        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): LogLineViewHolder {
            val view = LayoutInflater.from(parent.context).inflate(R.layout.elog_element_log_line, parent, false)
            return LogLineViewHolder(view)
        }

        override fun getItemCount() = logLines.size

        override fun onBindViewHolder(holder: LogLineViewHolder, position: Int) {
            (holder.itemView as TextView).text = logLines[position]
        }

        private inner class LogLineViewHolder(view: View) : RecyclerView.ViewHolder(view)
    }

    companion object {
        private const val ARG_LOG_FILE = "logfile.obj"

        internal fun start(ctx: Activity, logFile: LogFile) {
            val intent = Intent(ctx, LogViewerActivity::class.java)
            intent.putExtra(ARG_LOG_FILE, logFile)
            ctx.startActivity(intent)
        }
    }
}
