package app.raybritton.elog.data

import android.content.ContentProvider
import android.content.ContentValues
import android.database.Cursor
import android.net.Uri
import app.raybritton.elog.ELog
import app.raybritton.elog.arch.LogModule
import java.lang.UnsupportedOperationException

class ContextProvider : ContentProvider() {
    override fun insert(p0: Uri, p1: ContentValues?): Uri? {
        throw UnsupportedOperationException("Not a real content provider")
    }

    override fun query(p0: Uri, p1: Array<out String>?, p2: String?, p3: Array<out String>?, p4: String?): Cursor? {
        throw UnsupportedOperationException("Not a real content provider")
    }

    override fun onCreate(): Boolean {
        context?.let {
            ELog.context = it.applicationContext
            LogModule.logManager.cleanupLogs()
            return true
        } ?: throw IllegalStateException("Context not available")
    }

    override fun update(p0: Uri, p1: ContentValues?, p2: String?, p3: Array<out String>?): Int {
        throw UnsupportedOperationException("Not a real content provider")
    }

    override fun delete(p0: Uri, p1: String?, p2: Array<out String>?): Int {
        throw UnsupportedOperationException("Not a real content provider")
    }

    override fun getType(p0: Uri): String? {
        throw UnsupportedOperationException("Not a real content provider")
    }
}