/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.JsonUtils;
import ai.djl.util.Pair;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NoopServingTranslatorFactory
implements TranslatorFactory {
    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        String batchifier = ArgumentsUtil.stringValue(arguments, "batchifier", "none");
        return new NoopServingTranslator(Batchifier.fromString(batchifier));
    }

    static final class NoopServingTranslator
    implements Translator<Input, Output> {
        private static final String CSV_TRANSLATOR = "ai.djl.basicdataset.tabular.CsvTranslator";
        private Batchifier batchifier;
        private Translator<String, String> csvTranslator;

        NoopServingTranslator(Batchifier batchifier) {
            this.batchifier = batchifier;
            ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
            this.csvTranslator = ClassLoaderUtils.initClass(cl, Translator.class, CSV_TRANSLATOR);
        }

        @Override
        public Batchifier getBatchifier() {
            return this.batchifier;
        }

        @Override
        public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
            NDManager manager = ctx.getNDManager();
            try {
                ctx.setAttachment("properties", input.getProperties());
                String contentType = input.getProperty("Content-Type", null);
                if (contentType != null) {
                    int pos = contentType.indexOf(59);
                    if (pos > 0) {
                        contentType = contentType.substring(0, pos);
                    }
                    if ("application/json".equalsIgnoreCase(contentType)) {
                        JsonObject obj;
                        String data = input.getData().getAsString();
                        JsonElement element = (JsonElement)JsonUtils.GSON.fromJson(data, JsonElement.class);
                        if (element.isJsonObject() && (element = (obj = element.getAsJsonObject()).get("inputs")) == null) {
                            element = obj.get("instances");
                        }
                        if (element != null && element.isJsonArray()) {
                            return this.toNDList(manager, element);
                        }
                        throw new TranslateException("Input is not a supported json format");
                    }
                    if ("text/csv".equalsIgnoreCase(contentType)) {
                        if (this.csvTranslator == null) {
                            throw new TranslateException("CSV support not available. Add basicdataset dependency.");
                        }
                        return this.csvTranslator.processInput(ctx, input.getData().getAsString());
                    }
                }
                return input.getDataAsNDList(manager);
            }
            catch (IllegalArgumentException e) {
                throw new TranslateException("Input is not a NDList data type", e);
            }
        }

        @Override
        public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
            Map prop = (Map)ctx.getAttachment("properties");
            String contentType = prop.getOrDefault("Content-Type", "tensor/ndlist");
            int pos = contentType.indexOf(59);
            if (pos > 0) {
                contentType = contentType.substring(0, pos);
            }
            String accept = (String)prop.get("Accept");
            Output output = new Output();
            if ("tensor/npz".equalsIgnoreCase(accept) || "tensor/npz".equalsIgnoreCase(contentType)) {
                output.add(list.encode(NDList.Encoding.NPZ));
                output.addProperty("Content-Type", "tensor/npz");
            } else if ("tensor/safetensors".equalsIgnoreCase(accept) || "tensor/safetensors".equalsIgnoreCase(contentType)) {
                output.add(list.encode(NDList.Encoding.SAFETENSORS));
                output.addProperty("Content-Type", "tensor/safetensors");
            } else if ("text/csv".equalsIgnoreCase(accept)) {
                if (this.csvTranslator == null) {
                    throw new IllegalArgumentException("CSV support not available. Add basicdataset dependency.");
                }
                String csvOutput = (String)this.csvTranslator.processOutput(ctx, list);
                output.add(csvOutput);
                output.addProperty("Content-Type", "text/csv");
            } else if ("application/json".equalsIgnoreCase(accept) || "application/json".equalsIgnoreCase(contentType)) {
                List<Object> ret;
                if (list.size() == 1) {
                    ret = this.toList((NDArray)list.get(0));
                } else {
                    ret = new ArrayList();
                    for (NDArray array : list) {
                        ret.add(new Pair<String, List<Object>>(array.getName(), this.toList(array)));
                    }
                }
                ConcurrentHashMap<String, List<Object>> map = new ConcurrentHashMap<String, List<Object>>();
                map.put("predictions", ret);
                output.add("predictions", BytesSupplier.wrapAsJson(map));
            } else {
                output.add(list.encode());
                output.addProperty("Content-Type", "tensor/ndlist");
            }
            return output;
        }

        private NDList toNDList(NDManager manager, JsonElement element) {
            JsonElement e = element.getAsJsonArray().get(0);
            if (e.isJsonArray()) {
                float[][] array = (float[][])JsonUtils.GSON.fromJson(element, float[][].class);
                return new NDList(manager.create(array));
            }
            float[] array = (float[])JsonUtils.GSON.fromJson(element, float[].class);
            return new NDList(manager.create(array));
        }

        private List<Object> toList(NDArray array) {
            Number[] data = array.toArray();
            long[] shape = array.getShape().getShape();
            return this.toList(Arrays.asList(data).iterator(), shape, 0);
        }

        private List<Object> toList(Iterator<Number> data, long[] shape, int pos) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (pos == shape.length - 1) {
                int i = 0;
                while ((long)i < shape[pos]) {
                    ret.add(data.next());
                    ++i;
                }
                return ret;
            }
            int i = 0;
            while ((long)i < shape[pos]) {
                ret.add(this.toList(data, shape, pos + 1));
                ++i;
            }
            return ret;
        }
    }
}

