/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.audio;

import ai.djl.modality.audio.Audio;
import ai.djl.ndarray.NDArray;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioFactory {
    private static final Logger logger = LoggerFactory.getLogger(AudioFactory.class);
    private static final String[] FACTORIES = new String[]{"ai.djl.audio.FFmpegAudioFactory", "ai.djl.modality.audio.SampledAudioFactory"};
    protected int channels;
    protected int sampleRate;
    protected int sampleFormat;

    public static AudioFactory newInstance() {
        for (String f : FACTORIES) {
            try {
                Class<AudioFactory> clazz = Class.forName(f).asSubclass(AudioFactory.class);
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                logger.trace("", (Throwable)e);
            }
        }
        throw new IllegalStateException("Failed to create AudioFactory!");
    }

    public abstract Audio fromFile(Path var1) throws IOException;

    public Audio fromUrl(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Audio audio = this.fromInputStream(is);
            return audio;
        }
    }

    public Audio fromUrl(String url) throws IOException {
        URI uri = URI.create(url);
        if (uri.isAbsolute()) {
            return this.fromUrl(uri.toURL());
        }
        return this.fromFile(Paths.get(url, new String[0]));
    }

    public abstract Audio fromInputStream(InputStream var1) throws IOException;

    public Audio fromData(float[] data) {
        return new Audio(data);
    }

    public Audio fromNDArray(NDArray array) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public AudioFactory setChannels(int channels) {
        this.channels = channels;
        return this;
    }

    public int getChannels() {
        return this.channels;
    }

    public AudioFactory setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public AudioFactory setSampleFormat(int sampleFormat) {
        this.sampleFormat = sampleFormat;
        return this;
    }

    public int getSampleFormat() {
        return this.sampleFormat;
    }
}

